/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class CollapsibleWidget
extends WidgetGroup {
    private Table table;
    private CollapseAction collapseAction = new CollapseAction();
    private float collapseDuration = 0.3f;
    private Interpolation collapseInterpolation = Interpolation.pow3Out;
    private boolean collapsed;
    private boolean actionRunning;
    private float currentHeight;

    public CollapsibleWidget() {
    }

    public CollapsibleWidget(Table table) {
        this(table, false);
    }

    public CollapsibleWidget(Table table, boolean collapsed) {
        this.collapsed = collapsed;
        this.table = table;
        this.updateTouchable();
        if (table != null) {
            this.addActor((Actor)table);
        }
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.updateTouchable();
        if (this.table == null) {
            return;
        }
        this.actionRunning = true;
        if (withAnimation) {
            this.collapseAction.reset();
            this.collapseAction.setStart(this.currentHeight);
            this.collapseAction.setEnd(collapse ? 0.0f : this.table.getPrefHeight());
            this.collapseAction.setDuration(this.collapseDuration);
            this.collapseAction.setInterpolation(this.collapseInterpolation);
            this.addAction((Action)this.collapseAction);
        } else {
            if (collapse) {
                this.currentHeight = 0.0f;
                this.collapsed = true;
            } else {
                this.currentHeight = this.table.getPrefHeight();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private void updateTouchable() {
        if (this.collapsed) {
            this.setTouchable(Touchable.disabled);
        } else {
            this.setTouchable(Touchable.enabled);
        }
    }

    public void setCollapseDuration(float collapseDuration) {
        this.collapseDuration = collapseDuration;
    }

    public void setCollapseInterpolation(Interpolation collapseInterpolation) {
        this.collapseInterpolation = collapseInterpolation;
    }

    public void draw(Batch batch, float parentAlpha) {
        if (this.currentHeight > 1.0f) {
            batch.flush();
            boolean clipEnabled = this.clipBegin(this.getX(), this.getY(), this.getWidth(), this.currentHeight);
            super.draw(batch, parentAlpha);
            batch.flush();
            if (clipEnabled) {
                this.clipEnd();
            }
        }
    }

    public void layout() {
        if (this.table == null) {
            return;
        }
        this.table.setBounds(0.0f, 0.0f, this.table.getPrefWidth(), this.table.getPrefHeight());
        if (!this.actionRunning) {
            this.currentHeight = this.collapsed ? 0.0f : this.table.getPrefHeight();
        }
    }

    public float getPrefWidth() {
        return this.table == null ? 0.0f : this.table.getPrefWidth();
    }

    public float getPrefHeight() {
        if (this.table == null) {
            return 0.0f;
        }
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefHeight();
        }
        return this.currentHeight;
    }

    public void setTable(Table table) {
        this.table = table;
        this.clearChildren();
        this.addActor((Actor)table);
    }

    protected void childrenChanged() {
        super.childrenChanged();
        if (this.getChildren().size > 1) {
            throw new GdxRuntimeException("Only one actor can be added to CollapsibleWidget");
        }
    }

    private class CollapseAction
    extends FloatAction {
        private CollapseAction() {
        }

        protected void update(float percent) {
            super.update(percent);
            CollapsibleWidget.this.currentHeight = this.getValue();
            if (percent == 1.0f) {
                CollapsibleWidget.this.actionRunning = false;
                CollapsibleWidget.this.collapsed = CollapsibleWidget.this.currentHeight == 0.0f;
            }
            CollapsibleWidget.this.invalidateHierarchy();
        }
    }
}

