/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;

public class Separator
extends Widget {
    private SeparatorStyle style;

    public Separator() {
        this.style = (SeparatorStyle)VisUI.getSkin().get(SeparatorStyle.class);
    }

    public Separator(String styleName) {
        this.style = (SeparatorStyle)VisUI.getSkin().get(styleName, SeparatorStyle.class);
    }

    public Separator(SeparatorStyle style) {
        this.style = style;
    }

    public float getPrefHeight() {
        return this.style.thickness;
    }

    public float getPrefWidth() {
        return this.style.thickness;
    }

    public void draw(Batch batch, float parentAlpha) {
        Color c = this.getColor();
        batch.setColor(c.r, c.g, c.b, c.a * parentAlpha);
        this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public SeparatorStyle getStyle() {
        return this.style;
    }

    public static class SeparatorStyle {
        public Drawable background;
        public int thickness;

        public SeparatorStyle() {
        }

        public SeparatorStyle(SeparatorStyle style) {
            this.background = style.background;
            this.thickness = style.thickness;
        }

        public SeparatorStyle(Drawable bg, int thickness) {
            this.background = bg;
            this.thickness = thickness;
        }
    }
}

