/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;

public class VisCheckBox
extends TextButton
implements Focusable,
BorderOwner {
    private VisCheckBoxStyle style;
    private Image bgImage;
    private Image tickImage;
    private Stack imageStack;
    private Cell<Stack> imageStackCell;
    private boolean drawBorder;
    private boolean stateInvalid;
    private boolean focusBorderEnabled = true;

    public VisCheckBox(String text) {
        this(text, (VisCheckBoxStyle)((Object)VisUI.getSkin().get(VisCheckBoxStyle.class)));
    }

    public VisCheckBox(String text, boolean checked) {
        this(text, (VisCheckBoxStyle)((Object)VisUI.getSkin().get(VisCheckBoxStyle.class)));
        this.setChecked(checked);
    }

    public VisCheckBox(String text, String styleName) {
        this(text, (VisCheckBoxStyle)((Object)VisUI.getSkin().get(styleName, VisCheckBoxStyle.class)));
    }

    public VisCheckBox(String text, VisCheckBoxStyle style) {
        super(text, (TextButton.TextButtonStyle)style);
        this.clearChildren();
        this.bgImage = new Image(style.checkBackground);
        this.tickImage = new Image(style.tick);
        this.imageStack = new Stack(new Actor[]{this.bgImage, this.tickImage});
        this.imageStackCell = this.add((Actor)this.imageStack);
        Label label = this.getLabel();
        this.add((Actor)label).padLeft(5.0f);
        label.setAlignment(8);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!VisCheckBox.this.isDisabled()) {
                    FocusManager.switchFocus(VisCheckBox.this.getStage(), VisCheckBox.this);
                }
                return false;
            }
        });
    }

    public VisCheckBoxStyle getStyle() {
        return this.style;
    }

    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof VisCheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a VisCheckBoxStyle.");
        }
        super.setStyle(style);
        this.style = (VisCheckBoxStyle)style;
    }

    public void draw(Batch batch, float parentAlpha) {
        this.bgImage.setDrawable(this.getCheckboxBgImage());
        this.tickImage.setDrawable(this.getCheckboxTickImage());
        super.draw(batch, parentAlpha);
        if (!this.isDisabled() && this.stateInvalid && this.style.errorBorder != null) {
            this.style.errorBorder.draw(batch, this.getX() + this.imageStack.getX(), this.getY() + this.imageStack.getY(), this.imageStack.getWidth(), this.imageStack.getHeight());
        } else if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX() + this.imageStack.getX(), this.getY() + this.imageStack.getY(), this.imageStack.getWidth(), this.imageStack.getHeight());
        }
    }

    protected Drawable getCheckboxBgImage() {
        if (this.isDisabled()) {
            return this.style.checkBackground;
        }
        if (this.isPressed()) {
            return this.style.checkBackgroundDown;
        }
        if (this.isOver()) {
            return this.style.checkBackgroundOver;
        }
        return this.style.checkBackground;
    }

    protected Drawable getCheckboxTickImage() {
        if (this.isChecked()) {
            return this.isDisabled() ? this.style.tickDisabled : this.style.tick;
        }
        return null;
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public Image getTickImage() {
        return this.tickImage;
    }

    public Stack getImageStack() {
        return this.imageStack;
    }

    public Cell<Stack> getImageStackCell() {
        return this.imageStackCell;
    }

    public void setStateInvalid(boolean stateInvalid) {
        this.stateInvalid = stateInvalid;
    }

    public boolean setStateInvalid() {
        return this.stateInvalid;
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    public static class VisCheckBoxStyle
    extends TextButton.TextButtonStyle {
        public Drawable focusBorder;
        public Drawable errorBorder;
        public Drawable checkBackground;
        public Drawable checkBackgroundOver;
        public Drawable checkBackgroundDown;
        public Drawable tick;
        public Drawable tickDisabled;

        public VisCheckBoxStyle() {
        }

        public VisCheckBoxStyle(Drawable checkBackground, Drawable tick, BitmapFont font, Color fontColor) {
            this.checkBackground = checkBackground;
            this.tick = tick;
            this.font = font;
            this.fontColor = fontColor;
        }

        public VisCheckBoxStyle(VisCheckBoxStyle style) {
            super((TextButton.TextButtonStyle)style);
            this.focusBorder = style.focusBorder;
            this.errorBorder = style.errorBorder;
            this.checkBackground = style.checkBackground;
            this.checkBackgroundOver = style.checkBackgroundOver;
            this.checkBackgroundDown = style.checkBackgroundDown;
            this.tick = style.tick;
            this.tickDisabled = style.tickDisabled;
        }
    }
}

