/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.ObjectMap;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;

public class VisDialog
extends VisWindow {
    Table contentTable;
    Table buttonTable;
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();
    boolean cancelHide;
    Actor previousKeyboardFocus;
    Actor previousScrollFocus;
    FocusListener focusListener;
    protected InputListener ignoreTouchDown = new InputListener(){

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.cancel();
            return false;
        }
    };

    public VisDialog(String title) {
        super(title);
        this.skin = VisUI.getSkin();
        this.setSkin(this.skin);
        this.initialize();
    }

    public VisDialog(String title, String windowStyleName) {
        super(title, (Window.WindowStyle)VisUI.getSkin().get(windowStyleName, Window.WindowStyle.class));
        this.skin = VisUI.getSkin();
        this.setSkin(this.skin);
        this.initialize();
    }

    public VisDialog(String title, Window.WindowStyle windowStyle) {
        super(title, windowStyle);
        this.skin = VisUI.getSkin();
        this.setSkin(this.skin);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add((Actor)this.contentTable).expand().fill();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add((Actor)this.buttonTable);
        this.contentTable.defaults().space(2.0f).padLeft(3.0f).padRight(3.0f);
        this.buttonTable.defaults().space(6.0f).padBottom(3.0f);
        this.buttonTable.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!VisDialog.this.values.containsKey((Object)actor)) {
                    return;
                }
                while (actor.getParent() != VisDialog.this.buttonTable) {
                    actor = actor.getParent();
                }
                VisDialog.this.result(VisDialog.this.values.get((Object)actor));
                if (!VisDialog.this.cancelHide) {
                    VisDialog.this.hide();
                }
                VisDialog.this.cancelHide = false;
            }
        });
        this.focusListener = new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            public void scrollFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            private void focusChanged(FocusListener.FocusEvent event) {
                Actor newFocusedActor;
                Stage stage = VisDialog.this.getStage();
                if (VisDialog.this.isModal() && stage != null && stage.getRoot().getChildren().size > 0 && stage.getRoot().getChildren().peek() == VisDialog.this && (newFocusedActor = event.getRelatedActor()) != null && !newFocusedActor.isDescendantOf((Actor)VisDialog.this)) {
                    event.cancel();
                }
            }
        };
    }

    @Override
    protected void setStage(Stage stage) {
        if (stage == null) {
            this.addListener((EventListener)this.focusListener);
        } else {
            this.removeListener((EventListener)this.focusListener);
        }
        super.setStage(stage);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonsTable() {
        return this.buttonTable;
    }

    public VisDialog text(String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(text, (Label.LabelStyle)this.skin.get(Label.LabelStyle.class));
    }

    public VisDialog text(String text, Label.LabelStyle labelStyle) {
        return this.text(new Label((CharSequence)text, labelStyle));
    }

    public VisDialog text(Label label) {
        this.contentTable.add((Actor)label);
        return this;
    }

    public VisDialog button(String text) {
        return this.button(text, null);
    }

    public VisDialog button(String text, Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(text, object, (VisTextButton.VisTextButtonStyle)((Object)this.skin.get(VisTextButton.VisTextButtonStyle.class)));
    }

    public VisDialog button(String text, Object object, VisTextButton.VisTextButtonStyle buttonStyle) {
        return this.button((Button)new VisTextButton(text, buttonStyle), object);
    }

    public VisDialog button(Button button) {
        return this.button(button, null);
    }

    public VisDialog button(Button button, Object object) {
        this.buttonTable.add((Actor)button);
        this.setObject((Actor)button, object);
        return this;
    }

    public VisDialog show(Stage stage, Action action) {
        this.clearActions();
        this.removeCaptureListener((EventListener)this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousScrollFocus = actor;
        }
        this.pack();
        stage.addActor((Actor)this);
        stage.setKeyboardFocus((Actor)this);
        stage.setScrollFocus((Actor)this);
        if (action != null) {
            this.addAction(action);
        }
        return this;
    }

    public VisDialog show(Stage stage) {
        this.show(stage, (Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade)));
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        return this;
    }

    public void hide(Action action) {
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            this.removeListener((EventListener)this.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener((EventListener)this.ignoreTouchDown);
            this.addAction((Action)Actions.sequence((Action)action, (Action)Actions.removeListener((EventListener)this.ignoreTouchDown, (boolean)true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
    }

    public void hide() {
        this.hide((Action)Actions.sequence((Action)Actions.fadeOut((float)FADE_TIME, (Interpolation)Interpolation.fade), (Action)Actions.removeListener((EventListener)this.ignoreTouchDown, (boolean)true), (Action)Actions.removeActor()));
    }

    public void setObject(Actor actor, Object object) {
        this.values.put((Object)actor, object);
    }

    public VisDialog key(final int keycode, final Object object) {
        this.addListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode2) {
                if (keycode == keycode2) {
                    VisDialog.this.result(object);
                    if (!VisDialog.this.cancelHide) {
                        VisDialog.this.hide();
                    }
                    VisDialog.this.cancelHide = false;
                }
                return false;
            }
        });
        return this;
    }

    protected void result(Object object) {
    }

    public void cancel() {
        this.cancelHide = true;
    }
}

