/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;
import com.kotcrab.vis.ui.widget.Tooltip;

public class VisImageButton
extends Button
implements Focusable,
BorderOwner {
    private Image image;
    private VisImageButtonStyle style;
    private boolean drawBorder;
    private boolean focusBorderEnabled = true;
    private boolean generateDisabledImage = false;

    public VisImageButton(Drawable imageUp) {
        this(imageUp, null, null);
    }

    public VisImageButton(Drawable imageUp, String tooltipText) {
        this(imageUp, null, null);
        if (tooltipText != null) {
            new Tooltip.Builder(tooltipText).target((Actor)this).build();
        }
    }

    public VisImageButton(Drawable imageUp, Drawable imageDown) {
        this(imageUp, imageDown, null);
    }

    public VisImageButton(Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
        this(imageUp, imageDown, imageChecked, "default");
    }

    public VisImageButton(Drawable imageUp, Drawable imageDown, Drawable imageChecked, String styleName) {
        super((Button.ButtonStyle)new VisImageButtonStyle((VisImageButtonStyle)((Object)VisUI.getSkin().get(styleName, VisImageButtonStyle.class))));
        this.style.imageUp = imageUp;
        this.style.imageDown = imageDown;
        this.style.imageChecked = imageChecked;
        this.init();
    }

    public VisImageButton(String styleName) {
        super((Button.ButtonStyle)new VisImageButtonStyle((VisImageButtonStyle)((Object)VisUI.getSkin().get(styleName, VisImageButtonStyle.class))));
        this.init();
    }

    public VisImageButton(VisImageButtonStyle style) {
        super((Button.ButtonStyle)style);
        this.init();
    }

    private void init() {
        this.image = new Image();
        this.image.setScaling(Scaling.fit);
        this.add((Actor)this.image);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!VisImageButton.this.isDisabled()) {
                    FocusManager.switchFocus(VisImageButton.this.getStage(), VisImageButton.this);
                }
                return false;
            }
        });
        this.updateImage();
    }

    public VisImageButtonStyle getStyle() {
        return this.style;
    }

    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof VisImageButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        super.setStyle(style);
        this.style = (VisImageButtonStyle)style;
        if (this.image != null) {
            this.updateImage();
        }
    }

    private void updateImage() {
        Drawable drawable = null;
        if (this.isDisabled() && this.style.imageDisabled != null) {
            drawable = this.style.imageDisabled;
        } else if (this.isPressed() && this.style.imageDown != null) {
            drawable = this.style.imageDown;
        } else if (this.isChecked() && this.style.imageChecked != null) {
            drawable = this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked;
        } else if (this.isOver() && this.style.imageOver != null) {
            drawable = this.style.imageOver;
        } else if (this.style.imageUp != null) {
            drawable = this.style.imageUp;
        }
        this.image.setDrawable(drawable);
        if (this.generateDisabledImage && this.style.imageDisabled == null && this.isDisabled()) {
            this.image.setColor(Color.GRAY);
        } else {
            this.image.setColor(Color.WHITE);
        }
    }

    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        super.draw(batch, parentAlpha);
        if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.getCell((Actor)this.image);
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            FocusManager.resetFocus(this.getStage(), (Actor)this);
        }
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    public boolean isGenerateDisabledImage() {
        return this.generateDisabledImage;
    }

    public void setGenerateDisabledImage(boolean generate) {
        this.generateDisabledImage = generate;
    }

    public static class VisImageButtonStyle
    extends Button.ButtonStyle {
        public Drawable imageUp;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;
        public Drawable focusBorder;

        public VisImageButtonStyle() {
        }

        public VisImageButtonStyle(Drawable up, Drawable down, Drawable checked, Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
            super(up, down, checked);
            this.imageUp = imageUp;
            this.imageDown = imageDown;
            this.imageChecked = imageChecked;
        }

        public VisImageButtonStyle(VisImageButtonStyle style) {
            super((Button.ButtonStyle)style);
            this.imageUp = style.imageUp;
            this.imageDown = style.imageDown;
            this.imageOver = style.imageOver;
            this.imageChecked = style.imageChecked;
            this.imageCheckedOver = style.imageCheckedOver;
            this.imageDisabled = style.imageDisabled;
            this.focusBorder = style.focusBorder;
        }
    }
}

