/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color.internal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;

public class ColorInputField
extends VisValidatableTextField {
    private int value = 0;
    private int maxValue;

    public ColorInputField(final int maxValue, final ColorInputFieldListener listener) {
        super((InputValidator)new ColorFieldValidator(maxValue));
        this.maxValue = maxValue;
        this.setProgrammaticChangeEvents(false);
        this.setMaxLength(3);
        this.setTextFieldFilter(new NumberFilter());
        this.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ColorInputField.this.getText().length() > 0) {
                    ColorInputField.this.value = Integer.valueOf(ColorInputField.this.getText());
                }
            }
        });
        this.addListener((EventListener)new InputListener(){

            public boolean keyTyped(InputEvent event, char character) {
                ColorInputField field = (ColorInputField)event.getListenerActor();
                if (character == '+') {
                    field.changeValue(UIUtils.shift() ? 10 : 1);
                }
                if (character == '-') {
                    field.changeValue(UIUtils.shift() ? -10 : -1);
                }
                if (character != '\u0000') {
                    listener.changed(ColorInputField.this.getValue());
                }
                return true;
            }
        });
        this.addListener((EventListener)new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused && !ColorInputField.this.isInputValid()) {
                    ColorInputField.this.setValue(maxValue);
                }
            }
        });
    }

    public void changeValue(int byValue) {
        this.value += byValue;
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
        if (this.value < 0) {
            this.value = 0;
        }
        this.updateUI();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.updateUI();
    }

    private void updateUI() {
        this.setText(String.valueOf(this.value));
        this.setCursorPosition(this.getMaxLength());
    }

    private static class ColorFieldValidator
    implements InputValidator {
        private int maxValue;

        public ColorFieldValidator(int maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public boolean validateInput(String input) {
            if (input.equals("")) {
                return false;
            }
            Integer number = Integer.parseInt(input);
            return number <= this.maxValue;
        }
    }

    private static class NumberFilter
    implements VisTextField.TextFieldFilter {
        private NumberFilter() {
        }

        @Override
        public boolean acceptChar(VisTextField textField, char c) {
            return Character.isDigit(c);
        }
    }

    public static interface ColorInputFieldListener {
        public void changed(int var1);
    }
}

