/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.spinner;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.widget.spinner.AbstractSpinnerModel;
import com.kotcrab.vis.ui.widget.spinner.Spinner;

public class ArraySpinnerModel<T>
extends AbstractSpinnerModel {
    private Array<T> items = new Array();
    private T current;
    private int currentIndex;

    public ArraySpinnerModel() {
        super(false);
    }

    public ArraySpinnerModel(Array<T> items) {
        super(false);
        this.items.addAll(items);
    }

    @Override
    public void bind(Spinner spinner) {
        super.bind(spinner);
        this.updateCurrentItem(0);
        spinner.getTextField().addValidator(new InputValidator(){

            @Override
            public boolean validateInput(String input) {
                return ArraySpinnerModel.this.getItemIndexForText(input) != -1;
            }
        });
        spinner.notifyValueChanged(true);
    }

    protected String itemToString(T item) {
        if (item == null) {
            return "";
        }
        return item.toString();
    }

    private int getItemIndexForText(String text) {
        for (int i = 0; i < this.items.size; ++i) {
            Object item = this.items.get(i);
            if (!this.itemToString(item).equals(text)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void textChanged() {
        String text = this.spinner.getTextField().getText();
        int index = this.getItemIndexForText(text);
        if (index == -1) {
            return;
        }
        this.updateCurrentItem(index);
    }

    @Override
    public boolean incrementModel() {
        if (this.currentIndex + 1 >= this.items.size) {
            if (this.isWrap()) {
                this.updateCurrentItem(0);
                return true;
            }
            return false;
        }
        this.updateCurrentItem(this.currentIndex + 1);
        return true;
    }

    @Override
    public boolean decrementModel() {
        if (this.currentIndex - 1 < 0) {
            if (this.isWrap()) {
                this.updateCurrentItem(this.items.size - 1);
                return true;
            }
            return false;
        }
        this.updateCurrentItem(this.currentIndex - 1);
        return true;
    }

    @Override
    public String getText() {
        return this.itemToString(this.current);
    }

    public void invalidateDataSet() {
        this.updateCurrentItem(MathUtils.clamp((int)this.currentIndex, (int)0, (int)(this.items.size - 1)));
        this.spinner.notifyValueChanged(true);
    }

    public Array<T> getItems() {
        return this.items;
    }

    public void setItems(Array<T> newItems) {
        this.items.clear();
        this.items.addAll(newItems);
        this.currentIndex = 0;
        this.invalidateDataSet();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public T getCurrent() {
        return this.current;
    }

    public void setCurrent(int newIndex) {
        this.setCurrent(newIndex, this.spinner.isProgrammaticChangeEvents());
    }

    public void setCurrent(int newIndex, boolean fireEvent) {
        this.updateCurrentItem(newIndex);
        this.spinner.notifyValueChanged(fireEvent);
    }

    public void setCurrent(T item) {
        this.setCurrent(item, this.spinner.isProgrammaticChangeEvents());
    }

    public void setCurrent(T item, boolean fireEvent) {
        int index = this.items.indexOf(item, true);
        if (index == -1) {
            this.setCurrent(0, fireEvent);
        } else {
            this.setCurrent(index, fireEvent);
        }
    }

    private void updateCurrentItem(int newIndex) {
        if (this.items.size == 0) {
            this.current = null;
            this.currentIndex = -1;
        } else {
            this.currentIndex = newIndex;
            this.current = this.items.get(newIndex);
        }
    }
}

