/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.spinner;

import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.util.IntDigitsOnlyFilter;
import com.kotcrab.vis.ui.util.Validators;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import com.kotcrab.vis.ui.widget.spinner.AbstractSpinnerModel;
import com.kotcrab.vis.ui.widget.spinner.Spinner;

public class IntSpinnerModel
extends AbstractSpinnerModel {
    private BoundsValidator boundsValidator = new BoundsValidator();
    private IntDigitsOnlyFilter textFieldFilter;
    private int max;
    private int min;
    private int step;
    private int current;

    public IntSpinnerModel(int initialValue, int min, int max) {
        this(initialValue, min, max, 1);
    }

    public IntSpinnerModel(int initialValue, int min, int max, int step) {
        super(false);
        if (min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        if (step <= 0) {
            throw new IllegalArgumentException("step must be > 0");
        }
        this.current = initialValue;
        this.max = max;
        this.min = min;
        this.step = step;
    }

    @Override
    public void bind(Spinner spinner) {
        super.bind(spinner);
        VisValidatableTextField valueText = spinner.getTextField();
        valueText.getValidators().clear();
        valueText.addValidator(this.boundsValidator);
        valueText.addValidator(Validators.INTEGERS);
        this.textFieldFilter = new IntDigitsOnlyFilter(true);
        valueText.setTextFieldFilter(this.textFieldFilter);
        this.textFieldFilter.setUseFieldCursorPosition(true);
        if (this.min >= 0) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        } else {
            this.textFieldFilter.setAcceptNegativeValues(true);
        }
        spinner.notifyValueChanged(true);
    }

    @Override
    public void textChanged() {
        String text = this.spinner.getTextField().getText();
        if (text.equals("")) {
            this.current = this.min;
        } else if (this.checkInputBounds(text)) {
            this.current = Integer.parseInt(text);
        }
    }

    @Override
    public boolean incrementModel() {
        if (this.current + this.step > this.max) {
            if (this.current == this.max) {
                if (this.isWrap()) {
                    this.current = this.min;
                    return true;
                }
                return false;
            }
            this.current = this.max;
        } else {
            this.current += this.step;
        }
        return true;
    }

    @Override
    public boolean decrementModel() {
        if (this.current - this.step < this.min) {
            if (this.current == this.min) {
                if (this.isWrap()) {
                    this.current = this.max;
                    return true;
                }
                return false;
            }
            this.current = this.min;
        } else {
            this.current -= this.step;
        }
        return true;
    }

    @Override
    public String getText() {
        return String.valueOf(this.current);
    }

    public void setValue(int newValue) {
        this.setValue(newValue, this.spinner.isProgrammaticChangeEvents());
    }

    public void setValue(int newValue, boolean fireEvent) {
        this.current = newValue > this.max ? this.max : (newValue < this.min ? this.min : newValue);
        this.spinner.notifyValueChanged(fireEvent);
    }

    public int getValue() {
        return this.current;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        if (min > this.max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.min = min;
        if (min >= 0) {
            this.textFieldFilter.setAcceptNegativeValues(false);
        } else {
            this.textFieldFilter.setAcceptNegativeValues(true);
        }
        if (this.current < min) {
            this.current = min;
            this.spinner.notifyValueChanged(this.spinner.isProgrammaticChangeEvents());
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (this.min > max) {
            throw new IllegalArgumentException("min can't be > max");
        }
        this.max = max;
        if (this.current > max) {
            this.current = max;
            this.spinner.notifyValueChanged(this.spinner.isProgrammaticChangeEvents());
        }
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        if (step <= 0) {
            throw new IllegalArgumentException("step must be > 0");
        }
        this.step = step;
    }

    private boolean checkInputBounds(String input) {
        try {
            float x = Integer.parseInt(input);
            return x >= (float)this.min && x <= (float)this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private class BoundsValidator
    implements InputValidator {
        private BoundsValidator() {
        }

        @Override
        public boolean validateInput(String input) {
            return IntSpinnerModel.this.checkInputBounds(input);
        }
    }
}

