/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.tabbedpane;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Disposable;
import com.kotcrab.vis.ui.widget.tabbedpane.TabbedPane;

public abstract class Tab
implements Disposable {
    private boolean activeTab;
    private TabbedPane pane;
    private boolean closeableByUser = true;
    private boolean savable = false;
    private boolean dirty = false;

    public Tab() {
    }

    public Tab(boolean savable) {
        this.savable = savable;
    }

    public Tab(boolean savable, boolean closeableByUser) {
        this.savable = savable;
        this.closeableByUser = closeableByUser;
    }

    public abstract String getTabTitle();

    public abstract Table getContentTable();

    public void onShow() {
        this.activeTab = true;
    }

    public void onHide() {
        this.activeTab = false;
    }

    public boolean isActiveTab() {
        return this.activeTab;
    }

    public TabbedPane getPane() {
        return this.pane;
    }

    public void setPane(TabbedPane pane) {
        this.pane = pane;
    }

    public boolean isSavable() {
        return this.savable;
    }

    public boolean isCloseableByUser() {
        return this.closeableByUser;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean update;
        this.checkSavable();
        boolean bl = update = dirty != this.dirty;
        if (update) {
            this.dirty = dirty;
            if (this.pane != null) {
                this.getPane().updateTabTitle(this);
            }
        }
    }

    public void dirty() {
        this.setDirty(true);
    }

    public boolean save() {
        this.checkSavable();
        return false;
    }

    private void checkSavable() {
        if (!this.isSavable()) {
            throw new IllegalStateException("Tab " + this.getTabTitle() + " is not savable!");
        }
    }

    public void removeFromTabPane() {
        if (this.pane != null) {
            this.pane.remove(this);
        }
    }

    public void dispose() {
    }
}

