/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;

public class CursorManager {
    private static Cursor defaultCursor;
    private static Cursor.SystemCursor defaultSystemCursor;
    private static boolean systemCursorAsDefault;

    public static void setDefaultCursor(Cursor defaultCursor) {
        if (defaultCursor == null) {
            throw new IllegalArgumentException("defaultCursor can't be null");
        }
        CursorManager.defaultCursor = defaultCursor;
        systemCursorAsDefault = false;
    }

    public static void setDefaultCursor(Cursor.SystemCursor defaultCursor) {
        if (defaultCursor == null) {
            throw new IllegalArgumentException("defaultCursor can't be null");
        }
        defaultSystemCursor = defaultCursor;
        systemCursorAsDefault = true;
    }

    public static void restoreDefaultCursor() {
        if (systemCursorAsDefault) {
            Gdx.graphics.setSystemCursor(defaultSystemCursor);
        } else {
            Gdx.graphics.setCursor(defaultCursor);
        }
    }

    static {
        defaultSystemCursor = Cursor.SystemCursor.Arrow;
        systemCursorAsDefault = true;
    }
}

