/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.adapter;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.adapter.AbstractListAdapter;
import java.util.Comparator;

public abstract class ArrayAdapter<ItemT, ViewT extends Actor>
extends AbstractListAdapter<ItemT, ViewT> {
    private Array<ItemT> array;

    public ArrayAdapter(Array<ItemT> array) {
        this.array = array;
    }

    @Override
    public int indexOf(ItemT item) {
        return this.array.indexOf(item, true);
    }

    @Override
    public int size() {
        return this.array.size;
    }

    @Override
    public ItemT get(int index) {
        return (ItemT)this.array.get(index);
    }

    @Override
    public void add(ItemT element) {
        this.array.add(element);
        this.itemAdded(element);
    }

    @Override
    protected void sort(Comparator<ItemT> comparator) {
        this.array.sort(comparator);
    }

    @Override
    public Iterable<ItemT> iterable() {
        return this.array;
    }

    public void addAll(Array<? extends ItemT> array) {
        this.array.addAll(array);
        this.itemsChanged();
    }

    public void addAll(Array<? extends ItemT> array, int start, int count) {
        this.array.addAll(array, start, count);
        this.itemsChanged();
    }

    public void addAll(ItemT ... array) {
        this.array.addAll((Object[])array);
        this.itemsChanged();
    }

    public void addAll(ItemT[] array, int start, int count) {
        this.array.addAll((Object[])array, start, count);
        this.itemsChanged();
    }

    public void set(int index, ItemT value) {
        this.array.set(index, value);
        this.itemsChanged();
    }

    public void insert(int index, ItemT value) {
        this.array.insert(index, value);
        this.itemsChanged();
    }

    public void swap(int first, int second) {
        this.array.swap(first, second);
        this.itemsChanged();
    }

    public boolean removeValue(ItemT value, boolean identity) {
        boolean res = this.array.removeValue(value, identity);
        if (res) {
            this.itemRemoved(value);
        }
        return res;
    }

    public ItemT removeIndex(int index) {
        Object item = this.array.removeIndex(index);
        if (item != null) {
            this.itemRemoved(item);
        }
        return (ItemT)item;
    }

    public void removeRange(int start, int end) {
        this.array.removeRange(start, end);
        this.itemsChanged();
    }

    public boolean removeAll(Array<? extends ItemT> array, boolean identity) {
        boolean res = this.array.removeAll(array, identity);
        this.itemsChanged();
        return res;
    }

    public void clear() {
        this.array.clear();
        this.itemsChanged();
    }

    public void shuffle() {
        this.array.shuffle();
        this.itemsChanged();
    }

    public void reverse() {
        this.array.reverse();
        this.itemsChanged();
    }

    public ItemT pop() {
        Object item = this.array.pop();
        this.itemsChanged();
        return (ItemT)item;
    }
}

