/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Disposable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.ButtonBar;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisWindow;
import com.kotcrab.vis.ui.widget.color.ColorPickerListener;
import com.kotcrab.vis.ui.widget.color.ColorPickerStyle;
import com.kotcrab.vis.ui.widget.color.ExtendedColorPicker;
import com.kotcrab.vis.ui.widget.color.internal.ColorPickerText;

public class ColorPicker
extends VisWindow
implements Disposable {
    private ExtendedColorPicker picker;
    private ColorPickerListener listener;
    private VisTextButton restoreButton;
    private VisTextButton cancelButton;
    private VisTextButton okButton;
    private boolean closeAfterPickingFinished = true;
    private boolean fadeOutDueToCanceled;

    public ColorPicker() {
        this((String)null);
    }

    public ColorPicker(String title) {
        this("default", title, null);
    }

    public ColorPicker(String title, ColorPickerListener listener) {
        this("default", title, listener);
    }

    public ColorPicker(ColorPickerListener listener) {
        this("default", null, listener);
    }

    public ColorPicker(String styleName, String title, ColorPickerListener listener) {
        super(title != null ? title : "", (Window.WindowStyle)VisUI.getSkin().get(styleName, ColorPickerStyle.class));
        this.listener = listener;
        ColorPickerStyle style = (ColorPickerStyle)this.getStyle();
        if (title == null) {
            this.getTitleLabel().setText((CharSequence)ColorPickerText.TITLE.get());
        }
        this.setModal(true);
        this.setMovable(true);
        this.addCloseButton();
        this.closeOnEscape();
        this.picker = new ExtendedColorPicker(style.pickerStyle, listener);
        this.add((Actor)this.picker);
        this.row();
        this.add((Actor)this.createButtons()).pad(3.0f).right().expandX().colspan(3);
        this.pack();
        this.centerWindow();
        this.createListeners();
    }

    private VisTable createButtons() {
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setIgnoreSpacing(true);
        this.restoreButton = new VisTextButton(ColorPickerText.RESTORE.get());
        buttonBar.setButton(ButtonBar.ButtonType.LEFT, (Button)this.restoreButton);
        this.okButton = new VisTextButton(ColorPickerText.OK.get());
        buttonBar.setButton(ButtonBar.ButtonType.OK, (Button)this.okButton);
        this.cancelButton = new VisTextButton(ColorPickerText.CANCEL.get());
        buttonBar.setButton(ButtonBar.ButtonType.CANCEL, (Button)this.cancelButton);
        return buttonBar.createTable();
    }

    private void createListeners() {
        this.restoreButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.picker.restoreLastColor();
            }
        });
        this.okButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (ColorPicker.this.listener != null) {
                    ColorPicker.this.listener.finished(new Color(((ColorPicker)ColorPicker.this).picker.color));
                }
                ColorPicker.this.setColor(((ColorPicker)ColorPicker.this).picker.color);
                if (ColorPicker.this.closeAfterPickingFinished) {
                    ColorPicker.this.fadeOut();
                }
            }
        });
        this.cancelButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                ColorPicker.this.fadeOutDueToCanceled = true;
                ColorPicker.this.close();
            }
        });
    }

    @Override
    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage == null && this.fadeOutDueToCanceled) {
            this.fadeOutDueToCanceled = false;
            this.setColor(this.picker.oldColor);
        }
    }

    public void setCloseAfterPickingFinished(boolean closeAfterPickingFinished) {
        this.closeAfterPickingFinished = closeAfterPickingFinished;
    }

    @Override
    protected void close() {
        if (this.listener != null) {
            this.listener.canceled(this.picker.oldColor);
        }
        super.close();
    }

    public void dispose() {
        this.picker.dispose();
    }

    public ExtendedColorPicker getPicker() {
        return this.picker;
    }

    public boolean isShowHexFields() {
        return this.picker.isShowHexFields();
    }

    public void setShowHexFields(boolean showHexFields) {
        this.picker.setShowHexFields(showHexFields);
    }

    public boolean isDisposed() {
        return this.picker.isDisposed();
    }

    public void setAllowAlphaEdit(boolean allowAlphaEdit) {
        this.picker.setAllowAlphaEdit(allowAlphaEdit);
    }

    public boolean isAllowAlphaEdit() {
        return this.picker.isAllowAlphaEdit();
    }

    public void restoreLastColor() {
        this.picker.restoreLastColor();
    }

    public void setColor(Color newColor) {
        this.picker.setColor(newColor);
    }

    public void setListener(ColorPickerListener listener) {
        this.listener = listener;
        this.picker.setListener(listener);
    }

    public ColorPickerListener getListener() {
        return this.picker.getListener();
    }
}

