/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.internal.AbstractSuggestionPopup;
import com.kotcrab.vis.ui.widget.file.internal.ServiceThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DirsSuggestionPopup
extends AbstractSuggestionPopup {
    private final VisTextField pathField;
    private ExecutorService listDirExecutor = Executors.newSingleThreadExecutor(new ServiceThreadFactory("FileChooserListDirThread"));
    private Future<?> listDirFuture;

    public DirsSuggestionPopup(FileChooser chooser, VisTextField pathField) {
        super(chooser);
        this.pathField = pathField;
    }

    public void pathFieldKeyTyped(Stage stage, float width) {
        if (this.pathField.getText().length() == 0) {
            this.remove();
            return;
        }
        this.createDirSuggestions(stage, width);
    }

    private void createDirSuggestions(final Stage stage, final float width) {
        final String pathFieldText = this.pathField.getText();
        this.addAction((Action)Actions.sequence((Action)Actions.delay((float)0.2f, (Action)Actions.removeActor())));
        if (this.listDirFuture != null) {
            this.listDirFuture.cancel(true);
        }
        this.listDirFuture = this.listDirExecutor.submit(new Runnable(){

            @Override
            public void run() {
                String partialPath;
                FileHandle listDir;
                FileHandle enteredDir = Gdx.files.absolute(pathFieldText);
                if (enteredDir.exists()) {
                    listDir = enteredDir;
                    partialPath = "";
                } else {
                    listDir = enteredDir.parent();
                    partialPath = enteredDir.name();
                }
                final FileHandle[] files = listDir.list(DirsSuggestionPopup.this.chooser.getFileFilter());
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        DirsSuggestionPopup.this.clearChildren();
                        DirsSuggestionPopup.this.clearActions();
                        int suggestions = 0;
                        for (final FileHandle file : files) {
                            if (!file.exists() || !file.isDirectory() || !file.name().startsWith(partialPath) || file.name().equals(partialPath)) continue;
                            MenuItem item = DirsSuggestionPopup.this.createMenuItem(file.path());
                            item.getLabel().setEllipsis(true);
                            item.getLabelCell().width(width - 20.0f);
                            DirsSuggestionPopup.this.addItem(item);
                            item.addListener((EventListener)new ChangeListener(){

                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    DirsSuggestionPopup.this.chooser.setDirectory(file, FileChooser.HistoryPolicy.ADD);
                                }
                            });
                            if (++suggestions == 10) break;
                        }
                        if (suggestions == 0) {
                            DirsSuggestionPopup.this.remove();
                            return;
                        }
                        DirsSuggestionPopup.this.showMenu(stage, (Actor)DirsSuggestionPopup.this.pathField);
                        DirsSuggestionPopup.this.setWidth(width);
                        DirsSuggestionPopup.this.layout();
                    }
                });
            }
        });
    }

    public void showRecentDirectories(Stage stage, Array<FileHandle> recentDirectories, float width) {
        int suggestions = this.createRecentDirSuggestions(recentDirectories, width);
        if (suggestions == 0) {
            this.remove();
            return;
        }
        this.showMenu(stage, (Actor)this.pathField);
        this.setWidth(width);
        this.layout();
    }

    private int createRecentDirSuggestions(Array<FileHandle> files, float width) {
        this.clearChildren();
        int suggestions = 0;
        for (final FileHandle file : files) {
            if (!file.exists()) continue;
            MenuItem item = this.createMenuItem(file.path());
            item.getLabel().setEllipsis(true);
            item.getLabelCell().width(width - 20.0f);
            this.addItem(item);
            item.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    DirsSuggestionPopup.this.chooser.setDirectory(file, FileChooser.HistoryPolicy.ADD);
                }
            });
            if (++suggestions != 10) continue;
            break;
        }
        return suggestions;
    }
}

