/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.widget.file.internal.ServiceThreadFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DriveCheckerService {
    private static DriveCheckerService instance;
    private final ExecutorService pool;
    private Array<File> readableRoots = new Array();
    private Array<File> writableRoots = new Array();
    private Map<File, ListenerSet> readableListeners = new HashMap<File, ListenerSet>();
    private Map<File, ListenerSet> writableListeners = new HashMap<File, ListenerSet>();

    public static synchronized DriveCheckerService getInstance() {
        if (instance == null) {
            instance = new DriveCheckerService();
        }
        return instance;
    }

    public DriveCheckerService() {
        File[] roots;
        this.pool = Executors.newFixedThreadPool(3, new ServiceThreadFactory("DriveStatusChecker"));
        for (File root : roots = File.listRoots()) {
            this.processRoot(root);
        }
    }

    private void processRoot(final File root) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                DriveCheckerService.this.processResults(root, root.canRead(), root.canWrite());
            }
        });
    }

    private void processResults(final File root, final boolean readable, final boolean writable) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                ListenerSet set;
                if (readable) {
                    DriveCheckerService.this.readableRoots.add((Object)root);
                    set = (ListenerSet)DriveCheckerService.this.readableListeners.get(root);
                    if (set != null) {
                        set.notifyListeners(root, RootMode.READABLE);
                    }
                }
                if (writable) {
                    DriveCheckerService.this.writableRoots.add((Object)root);
                    set = (ListenerSet)DriveCheckerService.this.writableListeners.get(root);
                    if (set != null) {
                        set.notifyListeners(root, RootMode.WRITABLE);
                    }
                }
            }
        });
    }

    public void addListener(File root, RootMode mode, DriveCheckerListener listener) {
        switch (mode) {
            case READABLE: {
                this.addListener(root, mode, listener, this.readableRoots, this.readableListeners);
                break;
            }
            case WRITABLE: {
                this.addListener(root, mode, listener, this.writableRoots, this.writableListeners);
            }
        }
    }

    private void addListener(File root, RootMode mode, DriveCheckerListener listener, Array<File> cachedRoots, Map<File, ListenerSet> listeners) {
        if (cachedRoots.contains((Object)root, false)) {
            listener.rootMode(root, mode);
            return;
        }
        ListenerSet set = listeners.get(root);
        if (set == null) {
            set = new ListenerSet();
            listeners.put(root, set);
        }
        set.add(listener);
        this.processRoot(root);
    }

    public class ListenerSet {
        Array<DriveCheckerListener> list = new Array();

        public void add(DriveCheckerListener listener) {
            this.list.add((Object)listener);
        }

        public void notifyListeners(File root, RootMode mode) {
            Array.ArrayIterator it = this.list.iterator();
            while (it.hasNext()) {
                DriveCheckerListener listener = (DriveCheckerListener)it.next();
                listener.rootMode(root, mode);
                it.remove();
            }
        }
    }

    public static interface DriveCheckerListener {
        public void rootMode(File var1, RootMode var2);
    }

    public static enum RootMode {
        READABLE,
        WRITABLE;

    }
}

