/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;

public class PreferencesIO {
    private static final String VIS_DEFAULT_PREFS_NAME = "com.kotcrab.vis.ui.widget.file.filechooser_favorites";
    private static String defaultPrefsName = "com.kotcrab.vis.ui.widget.file.filechooser_favorites";
    private String favoritesKeyName = "favorites";
    private String recentDirKeyName = "recentDirectories";
    private String lastDirKeyName = "lastDirectory";
    private Preferences prefs;
    private Json json = new Json();

    public PreferencesIO() {
        this(defaultPrefsName);
    }

    public PreferencesIO(String prefsName) {
        this.prefs = Gdx.app.getPreferences(prefsName);
        this.checkIfUsingDefaultName();
    }

    public void checkIfUsingDefaultName() {
        if (defaultPrefsName.equals(VIS_DEFAULT_PREFS_NAME)) {
            Gdx.app.log("VisUI", "Warning, using default preferences file name for file chooser! (see FileChooser.setDefaultPrefsName(String))");
        }
    }

    public static void setDefaultPrefsName(String prefsName) {
        if (prefsName == null) {
            throw new IllegalStateException("prefsName can't be null");
        }
        defaultPrefsName = prefsName;
    }

    public Array<FileHandle> loadFavorites() {
        String data = this.prefs.getString(this.favoritesKeyName, null);
        if (data == null) {
            return new Array();
        }
        return ((FileArrayData)this.json.fromJson(FileArrayData.class, data)).toFileHandleArray();
    }

    public void saveFavorites(Array<FileHandle> favorites) {
        this.prefs.putString(this.favoritesKeyName, this.json.toJson((Object)new FileArrayData(favorites)));
        this.prefs.flush();
    }

    public Array<FileHandle> loadRecentDirectories() {
        String data = this.prefs.getString(this.recentDirKeyName, null);
        if (data == null) {
            return new Array();
        }
        return ((FileArrayData)this.json.fromJson(FileArrayData.class, data)).toFileHandleArray();
    }

    public void saveRecentDirectories(Array<FileHandle> recentDirs) {
        this.prefs.putString(this.recentDirKeyName, this.json.toJson((Object)new FileArrayData(recentDirs)));
        this.prefs.flush();
    }

    public FileHandle loadLastDirectory() {
        String data = this.prefs.getString(this.lastDirKeyName, null);
        if (data == null) {
            return null;
        }
        return ((FileHandleData)this.json.fromJson(FileHandleData.class, data)).toFileHandle();
    }

    public void saveLastDirectory(FileHandle file) {
        this.prefs.putString(this.lastDirKeyName, this.json.toJson((Object)new FileHandleData(file)));
        this.prefs.flush();
    }

    private static class FileHandleData {
        public Files.FileType type;
        public String path;

        public FileHandleData() {
        }

        public FileHandleData(FileHandle file) {
            this.type = file.type();
            this.path = file.path();
        }

        public FileHandle toFileHandle() {
            switch (this.type) {
                case Absolute: {
                    return Gdx.files.absolute(this.path);
                }
                case Classpath: {
                    return Gdx.files.classpath(this.path);
                }
                case External: {
                    return Gdx.files.external(this.path);
                }
                case Internal: {
                    return Gdx.files.internal(this.path);
                }
                case Local: {
                    return Gdx.files.local(this.path);
                }
            }
            throw new IllegalStateException("Unknown file type!");
        }
    }

    private static class FileArrayData {
        public Array<FileHandleData> data;

        public FileArrayData() {
        }

        public FileArrayData(Array<FileHandle> favourites) {
            this.data = new Array();
            for (FileHandle file : favourites) {
                this.data.add((Object)new FileHandleData(file));
            }
        }

        public Array<FileHandle> toFileHandleArray() {
            Array files = new Array();
            for (FileHandleData fileData : this.data) {
                files.add((Object)fileData.toFileHandle());
            }
            return files;
        }
    }
}

