/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.spinner;

import com.kotcrab.vis.ui.widget.spinner.Spinner;
import com.kotcrab.vis.ui.widget.spinner.SpinnerModel;

public abstract class AbstractSpinnerModel
implements SpinnerModel {
    protected Spinner spinner;
    private boolean allowRebind;
    private boolean wrap;

    public AbstractSpinnerModel(boolean allowRebind) {
        this.allowRebind = allowRebind;
    }

    @Override
    public void bind(Spinner spinner) {
        if (this.spinner != null && !this.allowRebind) {
            throw new IllegalStateException("this spinner model can't be reused");
        }
        this.spinner = spinner;
    }

    protected abstract boolean incrementModel();

    protected abstract boolean decrementModel();

    @Override
    public final boolean increment() {
        return this.increment(this.spinner.isProgrammaticChangeEvents());
    }

    @Override
    public final boolean increment(boolean fireEvent) {
        boolean valueChanged = this.incrementModel();
        if (valueChanged) {
            this.spinner.notifyValueChanged(fireEvent);
        }
        return valueChanged;
    }

    @Override
    public final boolean decrement() {
        return this.decrement(this.spinner.isProgrammaticChangeEvents());
    }

    @Override
    public final boolean decrement(boolean fireEvent) {
        boolean valueChanged = this.decrementModel();
        if (valueChanged) {
            this.spinner.notifyValueChanged(fireEvent);
        }
        return valueChanged;
    }

    @Override
    public boolean isWrap() {
        return this.wrap;
    }

    @Override
    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean isAllowRebind() {
        return this.allowRebind;
    }

    protected void setAllowRebind(boolean allowRebind) {
        this.allowRebind = allowRebind;
    }
}

