/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.spinner;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisImageButton;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import com.kotcrab.vis.ui.widget.spinner.SpinnerModel;

public class Spinner
extends VisTable
implements Disableable {
    private final Sizes sizes;
    private SpinnerModel model;
    private ButtonRepeatTask buttonRepeatTask = new ButtonRepeatTask();
    private VisImageButton upButton;
    private VisImageButton downButton;
    private Cell<VisValidatableTextField> textFieldCell;
    private Cell<VisLabel> labelCell;
    private TextFieldEventPolicy textFieldEventPolicy = TextFieldEventPolicy.ON_FOCUS_LOST;
    private boolean programmaticChangeEvents = true;
    private boolean disabled;

    public Spinner(String name, SpinnerModel model) {
        this("default", name, model);
    }

    public Spinner(String styleName, String name, SpinnerModel model) {
        this((SpinnerStyle)VisUI.getSkin().get(styleName, SpinnerStyle.class), VisUI.getSizes(), name, model);
    }

    public Spinner(SpinnerStyle style, Sizes sizes, String name, SpinnerModel model) {
        this.sizes = sizes;
        this.model = model;
        VisTable buttonsTable = new VisTable();
        VisValidatableTextField textField = this.createTextField();
        this.upButton = new VisImageButton(style.up);
        this.downButton = new VisImageButton(style.down);
        buttonsTable.add((Actor)this.upButton).height(sizes.spinnerButtonHeight).row();
        buttonsTable.add((Actor)this.downButton).height(sizes.spinnerButtonHeight);
        this.labelCell = this.add((Actor)new VisLabel(""));
        this.setSelectorName(name);
        this.textFieldCell = this.add((Actor)textField).height(sizes.spinnerButtonHeight * 2.0f).growX();
        this.add((Actor)buttonsTable);
        this.addButtonsListeners(this.upButton, this.downButton);
        model.bind(this);
    }

    private VisValidatableTextField createTextField() {
        VisValidatableTextField textField = new VisValidatableTextField(){

            @Override
            public float getPrefWidth() {
                return ((Spinner)Spinner.this).sizes.spinnerFieldSize;
            }
        };
        textField.setRestoreLastValid(true);
        textField.setProgrammaticChangeEvents(false);
        this.addTextFieldListeners(textField);
        return textField;
    }

    public void setModel(SpinnerModel model) {
        this.model = model;
        this.textFieldCell.setActor((Actor)this.createTextField());
        model.bind(this);
    }

    private void addButtonsListeners(VisImageButton upButton, VisImageButton downButton) {
        upButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                event.stop();
                Spinner.this.getStage().setScrollFocus((Actor)Spinner.this.getTextField());
                Spinner.this.increment(true);
            }
        });
        downButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                event.stop();
                Spinner.this.getStage().setScrollFocus((Actor)Spinner.this.getTextField());
                Spinner.this.decrement(true);
            }
        });
        upButton.addListener((EventListener)new ButtonInputListener(true));
        downButton.addListener((EventListener)new ButtonInputListener(false));
    }

    private void addTextFieldListeners(final VisTextField textField) {
        textField.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                event.stop();
                Spinner.this.model.textChanged();
                if (textField.isInputValid() && Spinner.this.textFieldEventPolicy == TextFieldEventPolicy.ON_KEY_TYPED) {
                    Spinner.this.notifyValueChanged(true);
                }
            }
        });
        textField.addListener((EventListener)new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    Spinner.this.getStage().setScrollFocus(null);
                    if (Spinner.this.textFieldEventPolicy == TextFieldEventPolicy.ON_FOCUS_LOST) {
                        Spinner.this.notifyValueChanged(true);
                    }
                }
            }
        });
        textField.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Spinner.this.getStage().setScrollFocus((Actor)Spinner.this.getTextField());
                return true;
            }

            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                if (Spinner.this.disabled) {
                    return false;
                }
                if (amountY >= 1.0f) {
                    Spinner.this.decrement(true);
                } else if (amountY <= -1.0f) {
                    Spinner.this.increment(true);
                }
                return true;
            }

            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    Spinner.this.notifyValueChanged(true);
                    return true;
                }
                return false;
            }
        });
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.upButton.setDisabled(disabled);
        this.downButton.setDisabled(disabled);
        this.getTextField().setDisabled(disabled);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setSelectorName(String name) {
        ((VisLabel)this.labelCell.getActor()).setText(name);
        if (name == null || name.length() == 0) {
            this.labelCell.padRight(0.0f);
        } else {
            this.labelCell.padRight(6.0f);
        }
    }

    public String getSelectorName() {
        return ((VisLabel)this.labelCell.getActor()).getText().toString();
    }

    public void increment() {
        this.model.increment(this.programmaticChangeEvents);
    }

    private void increment(boolean fireEvent) {
        this.model.increment(fireEvent);
    }

    public void decrement() {
        this.model.decrement(this.programmaticChangeEvents);
    }

    private void decrement(boolean fireEvent) {
        this.model.decrement(fireEvent);
    }

    public void setProgrammaticChangeEvents(boolean programmaticChangeEvents) {
        this.programmaticChangeEvents = programmaticChangeEvents;
    }

    public boolean isProgrammaticChangeEvents() {
        return this.programmaticChangeEvents;
    }

    public void setTextFieldEventPolicy(TextFieldEventPolicy textFieldEventPolicy) {
        this.textFieldEventPolicy = textFieldEventPolicy;
    }

    public TextFieldEventPolicy getTextFieldEventPolicy() {
        return this.textFieldEventPolicy;
    }

    public int getMaxLength() {
        return this.getTextField().getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.getTextField().setMaxLength(maxLength);
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void notifyValueChanged(boolean fireEvent) {
        VisValidatableTextField textField = this.getTextField();
        int cursor = textField.getCursorPosition();
        textField.setCursorPosition(0);
        textField.setText(this.model.getText());
        textField.setCursorPosition(cursor);
        if (fireEvent) {
            ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent.class);
            this.fire((Event)changeEvent);
            Pools.free((Object)changeEvent);
        }
    }

    public VisValidatableTextField getTextField() {
        return (VisValidatableTextField)this.textFieldCell.getActor();
    }

    private class ButtonInputListener
    extends InputListener {
        private float buttonRepeatInitialTime = 0.4f;
        private float buttonRepeatTime = 0.08f;
        private boolean advance;

        public ButtonInputListener(boolean advance) {
            this.advance = advance;
        }

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (!Spinner.this.buttonRepeatTask.isScheduled()) {
                ((Spinner)Spinner.this).buttonRepeatTask.advance = this.advance;
                Spinner.this.buttonRepeatTask.cancel();
                Timer.schedule((Timer.Task)Spinner.this.buttonRepeatTask, (float)this.buttonRepeatInitialTime, (float)this.buttonRepeatTime);
            }
            return true;
        }

        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            Spinner.this.buttonRepeatTask.cancel();
        }
    }

    public static enum TextFieldEventPolicy {
        ON_ENTER_ONLY,
        ON_FOCUS_LOST,
        ON_KEY_TYPED;

    }

    private class ButtonRepeatTask
    extends Timer.Task {
        boolean advance;

        private ButtonRepeatTask() {
        }

        public void run() {
            if (this.advance) {
                Spinner.this.increment(true);
            } else {
                Spinner.this.decrement(true);
            }
        }
    }

    public static class SpinnerStyle {
        public Drawable up;
        public Drawable down;

        public SpinnerStyle() {
        }

        public SpinnerStyle(SpinnerStyle style) {
            this.up = style.up;
            this.down = style.down;
        }

        public SpinnerStyle(Drawable up, Drawable down) {
            this.up = up;
            this.down = down;
        }
    }
}

