/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.building.utilities;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.kotcrab.vis.ui.building.utilities.Alignment;
import com.kotcrab.vis.ui.building.utilities.Nullables;
import com.kotcrab.vis.ui.building.utilities.Padding;

public class CellWidget<Widget extends Actor> {
    private static final int IGNORED_SIZE = 0;
    public static final CellWidget<?> EMPTY = CellWidget.empty();
    private final Widget widget;
    private final Padding padding;
    private final boolean expandX;
    private final boolean expandY;
    private final boolean fillX;
    private final boolean fillY;
    private final boolean useSpacing;
    private final Alignment alignment;
    private final int width;
    private final int height;
    private final int minWidth;
    private final int minHeight;

    private CellWidget(CellWidgetBuilder<Widget> cellWidgetBuilder) {
        this.widget = ((CellWidgetBuilder)cellWidgetBuilder).widget;
        this.padding = ((CellWidgetBuilder)cellWidgetBuilder).padding;
        this.expandX = ((CellWidgetBuilder)cellWidgetBuilder).expandX;
        this.expandY = ((CellWidgetBuilder)cellWidgetBuilder).expandY;
        this.fillX = ((CellWidgetBuilder)cellWidgetBuilder).fillX;
        this.fillY = ((CellWidgetBuilder)cellWidgetBuilder).fillY;
        this.useSpacing = ((CellWidgetBuilder)cellWidgetBuilder).useSpacing;
        this.alignment = ((CellWidgetBuilder)cellWidgetBuilder).alignment;
        this.width = ((CellWidgetBuilder)cellWidgetBuilder).width;
        this.height = ((CellWidgetBuilder)cellWidgetBuilder).height;
        this.minWidth = ((CellWidgetBuilder)cellWidgetBuilder).minWidth;
        this.minHeight = ((CellWidgetBuilder)cellWidgetBuilder).minHeight;
    }

    public static <Widget extends Actor> CellWidgetBuilder<Widget> of(Widget widget) {
        return new CellWidgetBuilder(widget);
    }

    public static <Widget extends Actor> CellWidgetBuilder<Widget> using(CellWidget<Widget> widget) {
        return new CellWidgetBuilder(widget);
    }

    public static <Widget extends Actor> CellWidget<Widget> wrap(Widget widget) {
        return CellWidget.of(widget).wrap();
    }

    public static CellWidget<?>[] wrap(Actor ... widgets) {
        CellWidget[] wrappedWidgets = new CellWidget[widgets.length];
        for (int index = 0; index < widgets.length; ++index) {
            wrappedWidgets[index] = CellWidget.of(widgets[index]).wrap();
        }
        return wrappedWidgets;
    }

    public static CellWidget<?> empty() {
        return CellWidget.builder().wrap();
    }

    public static CellWidgetBuilder<Actor> builder() {
        return CellWidget.of(null);
    }

    public Widget getWidget() {
        return this.widget;
    }

    public Cell<?> buildCell(Table table) {
        return this.buildCell(table, null);
    }

    public Cell<?> buildCell(Table table, Padding defaultWidgetPadding) {
        Cell cell = table.add(this.widget);
        this.applyPadding(cell, defaultWidgetPadding);
        this.applySizeData(cell);
        this.applyFillingData(cell);
        return cell;
    }

    private void applyPadding(Cell<?> cell, Padding defaultWidgetPadding) {
        Padding appliedPadding = Nullables.getOrElse(this.padding, defaultWidgetPadding);
        if (appliedPadding != null) {
            if (this.useSpacing) {
                appliedPadding.applySpacing(cell);
            } else {
                appliedPadding.applyPadding(cell);
            }
        }
    }

    private void applySizeData(Cell<?> cell) {
        if (this.width > 0) {
            cell.width((float)this.width);
        }
        if (this.height > 0) {
            cell.height((float)this.height);
        }
        if (this.minWidth > 0) {
            cell.minWidth((float)this.minWidth);
        }
        if (this.minHeight > 0) {
            cell.minHeight((float)this.minHeight);
        }
    }

    private void applyFillingData(Cell<?> cell) {
        if (this.alignment != null) {
            this.alignment.apply(cell);
        }
        cell.expand(this.expandX, this.expandY);
        cell.fill(this.fillX, this.fillY);
    }

    public static class CellWidgetBuilder<Widget extends Actor> {
        private Actor widget;
        private Padding padding;
        private boolean expandX;
        private boolean expandY;
        private boolean fillX;
        private boolean fillY;
        private boolean useSpacing;
        private Alignment alignment;
        private int width = 0;
        private int height = 0;
        private int minWidth = 0;
        private int minHeight = 0;

        private CellWidgetBuilder(Actor widget) {
            this.widget = widget;
        }

        private CellWidgetBuilder(CellWidget<Widget> widget) {
            this.widget = ((CellWidget)widget).widget;
            this.padding = ((CellWidget)widget).padding;
            this.expandX = ((CellWidget)widget).expandX;
            this.expandY = ((CellWidget)widget).expandY;
            this.fillX = ((CellWidget)widget).fillX;
            this.fillY = ((CellWidget)widget).fillY;
            this.useSpacing = ((CellWidget)widget).useSpacing;
            this.alignment = ((CellWidget)widget).alignment;
            this.width = ((CellWidget)widget).width;
            this.height = ((CellWidget)widget).height;
            this.minWidth = ((CellWidget)widget).minWidth;
            this.minHeight = ((CellWidget)widget).minHeight;
        }

        public CellWidget<Widget> wrap() {
            return new CellWidget(this);
        }

        public CellWidgetBuilder<Widget> widget(Widget widget) {
            this.widget = widget;
            return this;
        }

        public CellWidgetBuilder<Widget> padding(Padding padding) {
            this.padding = padding;
            return this;
        }

        public CellWidgetBuilder<Widget> useSpacing() {
            this.useSpacing = true;
            return this;
        }

        public CellWidgetBuilder<Widget> expandX() {
            this.expandX = true;
            return this;
        }

        public CellWidgetBuilder<Widget> expandY() {
            this.expandY = true;
            return this;
        }

        public CellWidgetBuilder<Widget> fillX() {
            this.fillX = true;
            return this;
        }

        public CellWidgetBuilder<Widget> fillY() {
            this.fillY = true;
            return this;
        }

        public CellWidgetBuilder<Widget> align(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public CellWidgetBuilder<Widget> width(int width) {
            this.width = width;
            return this;
        }

        public CellWidgetBuilder<Widget> height(int height) {
            this.height = height;
            return this;
        }

        public CellWidgetBuilder<Widget> minWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public CellWidgetBuilder<Widget> minHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }
    }
}

