/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.SnapshotArray;

public class FlowGroup
extends WidgetGroup {
    private static final float DEFAULT_SPACING = 0.0f;
    private boolean vertical;
    private float spacing;
    private boolean sizeInvalid = true;
    private float minWidth;
    private float minHeight;
    private float layoutedWidth;
    private float layoutedHeight;
    private float relaxedWidth;
    private float relaxedHeight;

    public FlowGroup(boolean vertical) {
        this(vertical, 0.0f);
    }

    public FlowGroup(boolean vertical, float spacing) {
        this.vertical = vertical;
        this.spacing = spacing;
        this.setTouchable(Touchable.childrenOnly);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        if (this.vertical == vertical) {
            return;
        }
        this.vertical = vertical;
        this.invalidate();
    }

    protected void computeSize() {
        if (this.vertical) {
            this.computeSizeVertical();
        } else {
            this.computeSizeHorizontal();
        }
    }

    protected void computeSizeHorizontal() {
        float targetWidth = this.getWidth();
        float maxChildWidth = 0.0f;
        float maxChildHeight = 0.0f;
        float x = 0.0f;
        float currentRowHeight = 0.0f;
        float totalWidth = 0.0f;
        float totalHeight = 0.0f;
        SnapshotArray children = this.getChildren();
        boolean wasChildProcessed = false;
        for (Actor child : children) {
            float childHeight;
            float childWidth;
            if (child instanceof Layout) {
                Layout layout = (Layout)child;
                childWidth = layout.getPrefWidth();
                childHeight = layout.getPrefHeight();
            } else {
                childWidth = child.getWidth();
                childHeight = child.getHeight();
            }
            if (x + childWidth <= targetWidth || !wasChildProcessed) {
                currentRowHeight = Math.max(childHeight, currentRowHeight);
            } else {
                totalHeight += currentRowHeight + this.spacing;
                x = 0.0f;
                currentRowHeight = childHeight;
            }
            float widthIncrement = childWidth + this.spacing;
            x += widthIncrement;
            totalWidth += widthIncrement;
            maxChildWidth = Math.max(maxChildWidth, childWidth);
            maxChildHeight = Math.max(maxChildHeight, childHeight);
            wasChildProcessed = true;
        }
        if (wasChildProcessed) {
            totalWidth -= this.spacing;
        }
        this.minWidth = maxChildWidth;
        this.minHeight = maxChildHeight;
        this.layoutedWidth = targetWidth;
        this.layoutedHeight = totalHeight += currentRowHeight;
        this.relaxedWidth = totalWidth;
        this.sizeInvalid = false;
    }

    protected void computeSizeVertical() {
        float targetHeight = this.getHeight();
        float maxChildWidth = 0.0f;
        float maxChildHeight = 0.0f;
        float y = targetHeight;
        float currentColumnWidth = 0.0f;
        float totalWidth = 0.0f;
        float totalHeight = 0.0f;
        SnapshotArray children = this.getChildren();
        boolean wasChildProcessed = false;
        for (Actor child : children) {
            float childHeight;
            float childWidth;
            if (child instanceof Layout) {
                Layout layout = (Layout)child;
                childWidth = layout.getPrefWidth();
                childHeight = layout.getPrefHeight();
            } else {
                childWidth = child.getWidth();
                childHeight = child.getHeight();
            }
            if (y - childHeight >= 0.0f || !wasChildProcessed) {
                currentColumnWidth = Math.max(childWidth, currentColumnWidth);
            } else {
                totalWidth += currentColumnWidth + this.spacing;
                y = targetHeight;
                currentColumnWidth = childWidth;
            }
            float heightIncrement = childHeight + this.spacing;
            y -= heightIncrement;
            totalHeight += heightIncrement;
            maxChildWidth = Math.max(maxChildWidth, childWidth);
            maxChildHeight = Math.max(maxChildHeight, childHeight);
            wasChildProcessed = true;
        }
        if (wasChildProcessed) {
            totalHeight -= this.spacing;
        }
        this.minWidth = maxChildWidth;
        this.minHeight = maxChildHeight;
        this.layoutedWidth = totalWidth += currentColumnWidth;
        this.layoutedHeight = targetHeight;
        this.relaxedHeight = totalHeight;
        this.sizeInvalid = false;
    }

    public void layout() {
        if (this.vertical) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    protected void layoutHorizontal() {
        this.computeSizeIfNeeded();
        float targetWidth = this.getWidth();
        float targetHeight = this.getHeight();
        float x = 0.0f;
        float y = targetHeight;
        float rowHeight = 0.0f;
        SnapshotArray children = this.getChildren();
        boolean wasChildProcessed = false;
        for (Actor child : children) {
            float childHeight;
            float childWidth;
            if (child instanceof Layout) {
                Layout layout = (Layout)child;
                childWidth = layout.getPrefWidth();
                childHeight = layout.getPrefHeight();
                child.setSize(childWidth, childHeight);
            } else {
                childWidth = child.getWidth();
                childHeight = child.getHeight();
            }
            if (x + childWidth <= targetWidth || !wasChildProcessed) {
                rowHeight = Math.max(childHeight, rowHeight);
            } else {
                x = 0.0f;
                y -= rowHeight + this.spacing;
                rowHeight = childHeight;
            }
            child.setPosition(x, y - childHeight);
            x += childWidth + this.spacing;
            wasChildProcessed = true;
        }
        if (this.getHeight() != this.layoutedHeight) {
            this.invalidateHierarchy();
        }
    }

    protected void layoutVertical() {
        this.computeSizeIfNeeded();
        float targetHeight = this.getHeight();
        float x = 0.0f;
        float y = targetHeight;
        float columnWidth = 0.0f;
        SnapshotArray children = this.getChildren();
        boolean wasChildProcessed = false;
        for (Actor child : children) {
            float childHeight;
            float childWidth;
            if (child instanceof Layout) {
                Layout layout = (Layout)child;
                childWidth = layout.getPrefWidth();
                childHeight = layout.getPrefHeight();
                child.setSize(childWidth, childHeight);
            } else {
                childWidth = child.getWidth();
                childHeight = child.getHeight();
            }
            if (y - childHeight >= 0.0f || !wasChildProcessed) {
                columnWidth = Math.max(childWidth, columnWidth);
            } else {
                x += columnWidth + this.spacing;
                y = targetHeight;
                columnWidth = childWidth;
            }
            child.setPosition(x, y - childHeight);
            y -= childHeight + this.spacing;
            wasChildProcessed = true;
        }
        if (this.getWidth() != this.layoutedWidth) {
            this.invalidateHierarchy();
        }
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.invalidateHierarchy();
    }

    public void invalidate() {
        this.sizeInvalid = true;
        super.invalidate();
    }

    public float getMinWidth() {
        this.computeSizeIfNeeded();
        return this.minWidth;
    }

    public float getMinHeight() {
        this.computeSizeIfNeeded();
        return this.minHeight;
    }

    public float getPrefWidth() {
        this.computeSizeIfNeeded();
        return this.vertical ? this.layoutedWidth : this.relaxedWidth;
    }

    public float getPrefHeight() {
        this.computeSizeIfNeeded();
        return this.vertical ? this.relaxedHeight : this.layoutedHeight;
    }

    protected void computeSizeIfNeeded() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
    }
}

