/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Timer;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.toast.Toast;
import com.kotcrab.vis.ui.widget.toast.ToastTable;

public class ToastManager {
    public static final int UNTIL_CLOSED = -1;
    protected final Group root;
    protected int screenPaddingX = 20;
    protected int screenPaddingY = 20;
    protected int messagePadding = 5;
    protected int alignment = 18;
    protected Array<Toast> toasts = new Array();
    protected ObjectMap<Toast, Timer.Task> timersTasks = new ObjectMap();

    public ToastManager(Stage stage) {
        WidgetGroup widgetGroup = new WidgetGroup();
        widgetGroup.setFillParent(true);
        widgetGroup.setTouchable(Touchable.childrenOnly);
        stage.addActor((Actor)widgetGroup);
        this.root = widgetGroup;
    }

    public ToastManager(Group root) {
        this.root = root;
    }

    public void show(String text) {
        this.show(text, -1.0f);
    }

    public void show(String text, float timeSec) {
        VisTable table = new VisTable();
        table.add(text).grow();
        this.show(table, timeSec);
    }

    public void show(Table table) {
        this.show(table, -1.0f);
    }

    public void show(Table table, float timeSec) {
        this.show(new Toast(table), timeSec);
    }

    public void show(ToastTable toastTable) {
        this.show(toastTable, -1.0f);
    }

    public void show(ToastTable toastTable, float timeSec) {
        Toast toast = toastTable.getToast();
        if (toast != null) {
            this.show(toast, timeSec);
        } else {
            this.show(new Toast(toastTable), timeSec);
        }
    }

    public void show(Toast toast) {
        this.show(toast, -1.0f);
    }

    public void show(final Toast toast, float timeSec) {
        Table toastMainTable = toast.getMainTable();
        if (toastMainTable.getStage() != null) {
            this.remove(toast);
        }
        this.toasts.add((Object)toast);
        toast.setToastManager(this);
        toast.fadeIn();
        toastMainTable.pack();
        this.root.addActor((Actor)toastMainTable);
        this.updateToastsPositions();
        if (timeSec > 0.0f) {
            Timer.Task fadeOutTask = new Timer.Task(){

                public void run() {
                    toast.fadeOut();
                    ToastManager.this.timersTasks.remove((Object)toast);
                }
            };
            this.timersTasks.put((Object)toast, (Object)fadeOutTask);
            Timer.schedule((Timer.Task)fadeOutTask, (float)timeSec);
        }
    }

    public void resize() {
        this.updateToastsPositions();
    }

    public boolean remove(Toast toast) {
        boolean removed = this.toasts.removeValue((Object)toast, true);
        if (removed) {
            toast.getMainTable().remove();
            Timer.Task timerTask = (Timer.Task)this.timersTasks.remove((Object)toast);
            if (timerTask != null) {
                timerTask.cancel();
            }
            this.updateToastsPositions();
        }
        return removed;
    }

    public void clear() {
        for (Toast toast : this.toasts) {
            toast.getMainTable().remove();
        }
        this.toasts.clear();
        for (Timer.Task task : this.timersTasks.values()) {
            task.cancel();
        }
        this.timersTasks.clear();
        this.updateToastsPositions();
    }

    public void toFront() {
        this.root.toFront();
    }

    protected void updateToastsPositions() {
        boolean bottom = (this.alignment & 4) != 0;
        boolean left = (this.alignment & 8) != 0;
        boolean center = (this.alignment & 1) != 0;
        float y = bottom ? (float)this.screenPaddingY : this.root.getHeight() - (float)this.screenPaddingY;
        for (Toast toast : this.toasts) {
            Table table = toast.getMainTable();
            float x = left ? (float)this.screenPaddingX : (center ? (this.root.getWidth() - table.getWidth() - (float)this.screenPaddingX) / 2.0f : this.root.getWidth() - table.getWidth() - (float)this.screenPaddingX);
            table.setPosition(x, bottom ? y : y - table.getHeight());
            y += (table.getHeight() + (float)this.messagePadding) * (float)(bottom ? 1 : -1);
        }
    }

    @Deprecated
    public int getScreenPadding() {
        if (this.screenPaddingX != this.screenPaddingY) {
            throw new IllegalStateException("Value of screen padding X is different than padding Y. Use either getScreenPaddingX or getScreenPaddingY.");
        }
        return this.screenPaddingX;
    }

    public int getScreenPaddingX() {
        return this.screenPaddingX;
    }

    public int getScreenPaddingY() {
        return this.screenPaddingY;
    }

    public void setScreenPadding(int screenPadding) {
        this.screenPaddingX = screenPadding;
        this.screenPaddingY = screenPadding;
        this.updateToastsPositions();
    }

    public void setScreenPadding(int screenPaddingX, int screenPaddingY) {
        this.screenPaddingX = screenPaddingX;
        this.screenPaddingY = screenPaddingY;
        this.updateToastsPositions();
    }

    public void setScreenPaddingX(int screenPaddingX) {
        this.screenPaddingX = screenPaddingX;
        this.updateToastsPositions();
    }

    public void setScreenPaddingY(int screenPaddingY) {
        this.screenPaddingY = screenPaddingY;
        this.updateToastsPositions();
    }

    public int getMessagePadding() {
        return this.messagePadding;
    }

    public void setMessagePadding(int messagePadding) {
        this.messagePadding = messagePadding;
        this.updateToastsPositions();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.updateToastsPositions();
    }
}

