/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.adapter;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.kotcrab.vis.ui.util.adapter.AbstractListAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public abstract class ArrayListAdapter<ItemT, ViewT extends Actor>
extends AbstractListAdapter<ItemT, ViewT> {
    private ArrayList<ItemT> array;

    public ArrayListAdapter(ArrayList<ItemT> array) {
        this.array = array;
    }

    @Override
    public Iterable<ItemT> iterable() {
        return this.array;
    }

    @Override
    public int size() {
        return this.array.size();
    }

    @Override
    public int indexOf(ItemT item) {
        return this.array.indexOf(item);
    }

    @Override
    public void add(ItemT element) {
        this.array.add(element);
        this.itemAdded(element);
    }

    @Override
    public ItemT get(int index) {
        return this.array.get(index);
    }

    @Override
    protected void sort(Comparator<ItemT> comparator) {
        Collections.sort(this.array, comparator);
    }

    public ItemT set(int index, ItemT element) {
        ItemT res = this.array.set(index, element);
        this.itemsChanged();
        return res;
    }

    public void add(int index, ItemT element) {
        this.array.add(index, element);
        this.itemAdded(element);
    }

    public ItemT remove(int index) {
        ItemT res = this.array.remove(index);
        if (res != null) {
            this.itemRemoved(res);
        }
        return res;
    }

    public boolean remove(ItemT item) {
        boolean res = this.array.remove(item);
        if (res) {
            this.itemRemoved(item);
        }
        return res;
    }

    public void clear() {
        this.array.clear();
        this.itemsChanged();
    }

    public boolean addAll(Collection<? extends ItemT> c) {
        boolean res = this.array.addAll(c);
        this.itemsChanged();
        return res;
    }

    public boolean addAll(int index, Collection<? extends ItemT> c) {
        boolean res = this.array.addAll(index, c);
        this.itemsChanged();
        return res;
    }

    public boolean removeAll(Collection<?> c) {
        boolean res = this.array.removeAll(c);
        this.itemsChanged();
        return res;
    }
}

