/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.dialog;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.I18NBundle;
import com.badlogic.gdx.utils.StringBuilder;
import com.kotcrab.vis.ui.Locales;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.i18n.BundleText;
import com.kotcrab.vis.ui.util.InputValidator;
import com.kotcrab.vis.ui.util.TableUtils;
import com.kotcrab.vis.ui.util.dialog.ConfirmDialogListener;
import com.kotcrab.vis.ui.util.dialog.InputDialogListener;
import com.kotcrab.vis.ui.util.dialog.OptionDialogListener;
import com.kotcrab.vis.ui.widget.ButtonBar;
import com.kotcrab.vis.ui.widget.VisDialog;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisScrollPane;
import com.kotcrab.vis.ui.widget.VisTable;
import com.kotcrab.vis.ui.widget.VisTextButton;
import com.kotcrab.vis.ui.widget.VisTextField;
import com.kotcrab.vis.ui.widget.VisValidatableTextField;
import com.kotcrab.vis.ui.widget.VisWindow;

public class Dialogs {
    private static final int BUTTON_OK = 1;
    private static final int BUTTON_DETAILS = 2;

    public static VisDialog showOKDialog(Stage stage, String title, String text) {
        final VisDialog dialog = new VisDialog(title);
        dialog.closeOnEscape();
        dialog.text(text);
        dialog.button(ButtonBar.ButtonType.OK.getText()).padBottom(3.0f);
        dialog.pack();
        dialog.centerWindow();
        dialog.addListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 66) {
                    dialog.fadeOut();
                    return true;
                }
                return false;
            }
        });
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static OptionDialog showOptionDialog(Stage stage, String title, String text, OptionDialogType type, OptionDialogListener listener) {
        OptionDialog dialog = new OptionDialog(title, text, type, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static <T> ConfirmDialog<T> showConfirmDialog(Stage stage, String title, String text, String[] buttons, T[] returns, ConfirmDialogListener<T> listener) {
        ConfirmDialog<T> dialog = new ConfirmDialog<T>(title, text, buttons, returns, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static InputDialog showInputDialog(Stage stage, String title, String fieldTitle, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, true, null, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static InputDialog showInputDialog(Stage stage, String title, String fieldTitle, InputValidator validator, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, true, validator, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static InputDialog showInputDialog(Stage stage, String title, String fieldTitle, boolean cancelable, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, cancelable, null, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static InputDialog showInputDialog(Stage stage, String title, String fieldTitle, boolean cancelable, InputValidator validator, InputDialogListener listener) {
        InputDialog dialog = new InputDialog(title, fieldTitle, cancelable, validator, listener);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static DetailsDialog showErrorDialog(Stage stage, String text) {
        return Dialogs.showErrorDialog(stage, text, (String)null);
    }

    public static DetailsDialog showErrorDialog(Stage stage, String text, Throwable exception) {
        if (exception == null) {
            return Dialogs.showErrorDialog(stage, text, (String)null);
        }
        return Dialogs.showErrorDialog(stage, text, Dialogs.getStackTrace(exception));
    }

    public static DetailsDialog showErrorDialog(Stage stage, String text, String details) {
        DetailsDialog dialog = new DetailsDialog(text, Text.ERROR.get(), details);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    public static DetailsDialog showDetailsDialog(Stage stage, String text, String title, String details) {
        return Dialogs.showDetailsDialog(stage, text, title, details, false);
    }

    public static DetailsDialog showDetailsDialog(Stage stage, String text, String title, String details, boolean expandDetails) {
        DetailsDialog dialog = new DetailsDialog(text, title, details);
        dialog.setDetailsVisible(expandDetails);
        stage.addActor((Actor)dialog.fadeIn());
        return dialog;
    }

    private static VisScrollPane createScrollPane(Actor widget) {
        VisScrollPane scrollPane = new VisScrollPane(widget);
        scrollPane.setOverscroll(false, true);
        scrollPane.setFadeScrollBars(false);
        return scrollPane;
    }

    private static String getStackTrace(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        Dialogs.getStackTrace(throwable, builder);
        return builder.toString();
    }

    private static void getStackTrace(Throwable throwable, StringBuilder builder) {
        String msg = throwable.getMessage();
        if (msg != null) {
            builder.append(msg);
            builder.append("\n\n");
        }
        for (StackTraceElement element : throwable.getStackTrace()) {
            builder.append((Object)element);
            builder.append("\n");
        }
        if (throwable.getCause() != null) {
            builder.append("\nCaused by: ");
            Dialogs.getStackTrace(throwable.getCause(), builder);
        }
    }

    private static enum Text implements BundleText
    {
        DETAILS("details"),
        DETAILS_COLON("detailsColon"),
        COPY("copy"),
        COPIED("copied"),
        ERROR("error");

        private final String name;

        private Text(String name) {
            this.name = name;
        }

        private static I18NBundle getBundle() {
            return Locales.getDialogsBundle();
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final String get() {
            return Text.getBundle().get(this.name);
        }

        @Override
        public final String format() {
            return Text.getBundle().format(this.name, new Object[0]);
        }

        @Override
        public final String format(Object ... arguments) {
            return Text.getBundle().format(this.name, arguments);
        }

        public final String toString() {
            return this.get();
        }
    }

    public static class ConfirmDialog<T>
    extends VisDialog {
        private ConfirmDialogListener<T> listener;

        public ConfirmDialog(String title, String text, String[] buttons, T[] returns, ConfirmDialogListener<T> listener) {
            super(title);
            if (buttons.length != returns.length) {
                throw new IllegalStateException("buttons.length must be equal to returns.length");
            }
            this.listener = listener;
            this.text(new VisLabel((CharSequence)text, 1));
            this.defaults().padBottom(3.0f);
            for (int i = 0; i < buttons.length; ++i) {
                this.button(buttons[i], returns[i]);
            }
            this.padBottom(3.0f);
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void result(Object object) {
            this.listener.result(object);
        }
    }

    public static class DetailsDialog
    extends VisDialog {
        private VisTable detailsTable = new VisTable(true);
        private Cell<?> detailsCell;
        private boolean detailsVisible;
        private VisTextButton copyButton;
        private VisLabel detailsLabel;

        public DetailsDialog(String text, String title, String details) {
            super(title);
            this.text(text);
            if (details != null) {
                this.copyButton = new VisTextButton(Text.COPY.get());
                this.detailsLabel = new VisLabel(details);
                Sizes sizes = VisUI.getSizes();
                this.copyButton.addListener((EventListener)new ChangeListener(){

                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        Gdx.app.getClipboard().setContents(detailsLabel.getText().toString());
                        copyButton.setText(Text.COPIED.get());
                    }
                });
                this.detailsTable.add((Actor)new VisLabel(Text.DETAILS_COLON.get())).left().expand().padTop(6.0f);
                this.detailsTable.add((Actor)this.copyButton);
                this.detailsTable.row();
                VisTable detailsTable = new VisTable();
                detailsTable.add((Actor)this.detailsLabel).top().expand().fillX();
                this.detailsTable.add((Actor)Dialogs.createScrollPane((Actor)detailsTable)).colspan(2).minWidth(600.0f * sizes.scaleFactor).height(300.0f * sizes.scaleFactor);
                this.getContentTable().row();
                this.detailsCell = this.getContentTable().add((Actor)this.detailsTable);
                this.detailsCell.setActor(null);
                this.button(Text.DETAILS.get(), (Object)2);
            }
            this.button(ButtonBar.ButtonType.OK.getText(), (Object)1).padBottom(3.0f);
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void result(Object object) {
            int result = (Integer)object;
            if (result == 2) {
                this.setDetailsVisible(!this.detailsVisible);
                this.cancel();
            }
        }

        public void setWrapDetails(boolean wrap) {
            this.detailsLabel.setWrap(wrap);
        }

        public void setCopyDetailsButtonVisible(boolean visible) {
            this.copyButton.setVisible(visible);
        }

        public boolean isCopyDetailsButtonVisible() {
            return this.copyButton.isVisible();
        }

        public void setDetailsVisible(boolean visible) {
            if (this.detailsVisible == visible) {
                return;
            }
            this.detailsVisible = visible;
            this.detailsCell.setActor((Actor)(this.detailsCell.hasActor() ? null : this.detailsTable));
            if (this.getStage() == null) {
                Gdx.app.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        this.pack();
                        this.centerWindow();
                    }
                });
            } else {
                this.pack();
                this.centerWindow();
            }
        }

        public boolean isDetailsVisible() {
            return this.detailsVisible;
        }
    }

    public static class OptionDialog
    extends VisWindow {
        private final ButtonBar buttonBar;

        public OptionDialog(String title, String text, OptionDialogType type, final OptionDialogListener listener) {
            super(title);
            this.setModal(true);
            this.add((Actor)new VisLabel((CharSequence)text, 1));
            this.row();
            this.defaults().space(6.0f);
            this.defaults().padBottom(3.0f);
            this.buttonBar = new ButtonBar();
            this.buttonBar.setIgnoreSpacing(true);
            ChangeListener yesBtnListener = new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    listener.yes();
                    this.fadeOut();
                }
            };
            ChangeListener noBtnListener = new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    listener.no();
                    this.fadeOut();
                }
            };
            ChangeListener cancelBtnListener = new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    listener.cancel();
                    this.fadeOut();
                }
            };
            switch (type) {
                case YES_NO: {
                    this.buttonBar.setButton(ButtonBar.ButtonType.YES, yesBtnListener);
                    this.buttonBar.setButton(ButtonBar.ButtonType.NO, noBtnListener);
                    break;
                }
                case YES_CANCEL: {
                    this.buttonBar.setButton(ButtonBar.ButtonType.YES, yesBtnListener);
                    this.buttonBar.setButton(ButtonBar.ButtonType.CANCEL, cancelBtnListener);
                    break;
                }
                case YES_NO_CANCEL: {
                    this.buttonBar.setButton(ButtonBar.ButtonType.YES, yesBtnListener);
                    this.buttonBar.setButton(ButtonBar.ButtonType.NO, noBtnListener);
                    this.buttonBar.setButton(ButtonBar.ButtonType.CANCEL, cancelBtnListener);
                }
            }
            this.add((Actor)this.buttonBar.createTable());
            this.pack();
            this.centerWindow();
        }

        public OptionDialog setNoButtonText(String text) {
            this.buttonBar.getTextButton(ButtonBar.ButtonType.NO).setText(text);
            this.pack();
            return this;
        }

        public OptionDialog setYesButtonText(String text) {
            this.buttonBar.getTextButton(ButtonBar.ButtonType.YES).setText(text);
            this.pack();
            return this;
        }

        public OptionDialog setCancelButtonText(String text) {
            this.buttonBar.getTextButton(ButtonBar.ButtonType.CANCEL).setText(text);
            this.pack();
            return this;
        }
    }

    public static class InputDialog
    extends VisWindow {
        private InputDialogListener listener;
        private VisTextField field;
        private VisTextButton okButton;
        private VisTextButton cancelButton;

        public InputDialog(String title, String fieldTitle, boolean cancelable, InputValidator validator, InputDialogListener listener) {
            super(title);
            this.listener = listener;
            TableUtils.setSpacingDefaults((Table)this);
            this.setModal(true);
            if (cancelable) {
                this.addCloseButton();
                this.closeOnEscape();
            }
            ButtonBar buttonBar = new ButtonBar();
            buttonBar.setIgnoreSpacing(true);
            this.cancelButton = new VisTextButton(ButtonBar.ButtonType.CANCEL.getText());
            buttonBar.setButton(ButtonBar.ButtonType.CANCEL, (Button)this.cancelButton);
            this.okButton = new VisTextButton(ButtonBar.ButtonType.OK.getText());
            buttonBar.setButton(ButtonBar.ButtonType.OK, (Button)this.okButton);
            VisTable fieldTable = new VisTable(true);
            this.field = validator == null ? new VisTextField() : new VisValidatableTextField(validator);
            if (fieldTitle != null) {
                fieldTable.add((Actor)new VisLabel(fieldTitle));
            }
            fieldTable.add((Actor)this.field).expand().fill();
            this.add((Actor)fieldTable).padTop(3.0f).spaceBottom(4.0f);
            this.row();
            this.add((Actor)buttonBar.createTable()).padBottom(3.0f);
            this.addListeners();
            if (validator != null) {
                this.addValidatableFieldListener(this.field);
                this.okButton.setDisabled(!this.field.isInputValid());
            }
            this.pack();
            this.centerWindow();
        }

        @Override
        protected void close() {
            super.close();
            this.listener.canceled();
        }

        @Override
        protected void setStage(Stage stage) {
            super.setStage(stage);
            if (stage != null) {
                this.field.focusField();
            }
        }

        public InputDialog setText(String text) {
            return this.setText(text, false);
        }

        public InputDialog setText(String text, boolean selectText) {
            this.field.setText(text);
            this.field.setCursorPosition(text.length());
            if (selectText) {
                this.field.selectAll();
            }
            return this;
        }

        private InputDialog addValidatableFieldListener(final VisTextField field) {
            field.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (field.isInputValid()) {
                        okButton.setDisabled(false);
                    } else {
                        okButton.setDisabled(true);
                    }
                }
            });
            return this;
        }

        private void addListeners() {
            this.okButton.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    listener.finished(field.getText());
                    this.fadeOut();
                }
            });
            this.cancelButton.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    this.close();
                }
            });
            this.field.addListener((EventListener)new InputListener(){

                public boolean keyDown(InputEvent event, int keycode) {
                    if (keycode == 66 && !okButton.isDisabled()) {
                        listener.finished(field.getText());
                        this.fadeOut();
                    }
                    return super.keyDown(event, keycode);
                }
            });
        }
    }

    public static enum OptionDialogType {
        YES_NO,
        YES_NO_CANCEL,
        YES_CANCEL;

    }
}

