/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.CursorManager;
import com.kotcrab.vis.ui.widget.VisLabel;

public class LinkLabel
extends VisLabel {
    private static final Color tempColor = new Color();
    private LinkLabelStyle style;
    private ClickListener clickListener;
    private LinkLabelListener listener;
    private CharSequence url;

    public LinkLabel(CharSequence url) {
        super(url, (Label.LabelStyle)VisUI.getSkin().get(LinkLabelStyle.class));
        this.init(url);
    }

    public LinkLabel(CharSequence text, CharSequence url) {
        super(text, (Label.LabelStyle)VisUI.getSkin().get(LinkLabelStyle.class));
        this.init(url);
    }

    public LinkLabel(CharSequence text, int alignment) {
        super(text, (Label.LabelStyle)VisUI.getSkin().get(LinkLabelStyle.class));
        this.setAlignment(alignment);
        this.init(text);
    }

    public LinkLabel(CharSequence text, Color textColor) {
        super(text, (Label.LabelStyle)VisUI.getSkin().get(LinkLabelStyle.class));
        this.setColor(textColor);
        this.init(text);
    }

    public LinkLabel(CharSequence text, LinkLabelStyle style) {
        super(text, style);
        this.init(text);
    }

    public LinkLabel(CharSequence text, CharSequence url, String styleName) {
        super(text, (Label.LabelStyle)VisUI.getSkin().get(styleName, LinkLabelStyle.class));
        this.init(url);
    }

    public LinkLabel(CharSequence text, CharSequence url, LinkLabelStyle style) {
        super(text, style);
        this.init(url);
    }

    public LinkLabel(CharSequence text, String fontName, Color color) {
        super(text, new LinkLabelStyle(VisUI.getSkin().getFont(fontName), color, VisUI.getSkin().getDrawable("white")));
        this.init(text);
    }

    public LinkLabelStyle getStyle() {
        return (LinkLabelStyle)super.getStyle();
    }

    private void init(CharSequence linkUrl) {
        this.url = linkUrl;
        this.style = this.getStyle();
        this.clickListener = new ClickListener(0){

            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (LinkLabel.this.listener == null) {
                    Gdx.net.openURI(LinkLabel.this.url.toString());
                } else {
                    LinkLabel.this.listener.clicked(LinkLabel.this.url.toString());
                }
            }

            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Hand);
            }

            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                super.exit(event, x, y, pointer, toActor);
                CursorManager.restoreDefaultCursor();
            }
        };
        this.addListener((EventListener)this.clickListener);
    }

    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        Drawable underline = this.style.underline;
        if (underline != null && this.clickListener.isOver()) {
            Color color = tempColor.set(this.getColor());
            color.a *= parentAlpha;
            if (this.style.fontColor != null) {
                color.mul(this.style.fontColor);
            }
            batch.setColor(color);
            underline.draw(batch, this.getX(), this.getY(), this.getWidth(), 1.0f);
        }
    }

    public CharSequence getUrl() {
        return this.url;
    }

    public void setUrl(CharSequence url) {
        this.url = url;
    }

    public LinkLabelListener getListener() {
        return this.listener;
    }

    public void setListener(LinkLabelListener listener) {
        this.listener = listener;
    }

    public static class LinkLabelStyle
    extends Label.LabelStyle {
        public Drawable underline;

        public LinkLabelStyle() {
        }

        public LinkLabelStyle(BitmapFont font, Color fontColor, Drawable underline) {
            super(font, fontColor);
            this.underline = underline;
        }

        public LinkLabelStyle(LinkLabelStyle style) {
            super((Label.LabelStyle)style);
            this.underline = style.underline;
        }
    }

    public static interface LinkLabelListener {
        public void clicked(String var1);
    }
}

