/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.Focusable;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.util.BorderOwner;
import com.kotcrab.vis.ui.widget.VisTextButton;

public class VisImageTextButton
extends Button
implements Focusable,
BorderOwner {
    private Image image;
    private Label label;
    private boolean drawBorder;
    private boolean focusBorderEnabled = true;
    private boolean generateDisabledImage = false;
    private VisImageTextButtonStyle style;
    private Orientation orientation = Orientation.TEXT_RIGHT;

    public VisImageTextButton(String text, Drawable imageUp) {
        this(text, "default", imageUp, null);
    }

    public VisImageTextButton(String text, String styleName, Drawable imageUp) {
        this(text, styleName, imageUp, null);
    }

    public VisImageTextButton(String text, String styleName, Drawable imageUp, Drawable imageDown) {
        super((Button.ButtonStyle)new VisImageTextButtonStyle((VisImageTextButtonStyle)((Object)VisUI.getSkin().get(styleName, VisImageTextButtonStyle.class))));
        this.style.imageUp = imageUp;
        this.style.imageDown = imageDown;
        this.init(text);
    }

    public VisImageTextButton(String text, String styleName) {
        super((Button.ButtonStyle)new VisImageTextButtonStyle((VisImageTextButtonStyle)((Object)VisUI.getSkin().get(styleName, VisImageTextButtonStyle.class))));
        this.init(text);
    }

    public VisImageTextButton(String text, VisImageTextButtonStyle style) {
        super((Button.ButtonStyle)style);
        this.init(text);
    }

    private void init(String text) {
        this.defaults().space(3.0f);
        this.image = new Image();
        this.image.setScaling(Scaling.fit);
        this.label = new Label((CharSequence)text, new Label.LabelStyle(this.style.font, this.style.fontColor));
        this.label.setAlignment(1);
        this.addActorsBasedOnOrientation();
        this.setStyle((Button.ButtonStyle)this.style);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (!VisImageTextButton.this.isDisabled()) {
                    FocusManager.switchFocus(VisImageTextButton.this.getStage(), VisImageTextButton.this);
                }
                return false;
            }
        });
    }

    private void addActorsBasedOnOrientation() {
        switch (this.orientation) {
            case TEXT_RIGHT: {
                this.add((Actor)this.image);
                this.add((Actor)this.label);
                break;
            }
            case TEXT_LEFT: {
                this.add((Actor)this.label);
                this.add((Actor)this.image);
                break;
            }
            case TEXT_TOP: {
                this.add((Actor)this.label);
                this.row();
                this.add((Actor)this.image);
                break;
            }
            case TEXT_BOTTOM: {
                this.add((Actor)this.image);
                this.row();
                this.add((Actor)this.label);
            }
        }
    }

    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof VisImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a VisImageTextButtonStyle.");
        }
        super.setStyle(style);
        this.style = (VisImageTextButtonStyle)style;
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            VisImageTextButtonStyle textButtonStyle = (VisImageTextButtonStyle)style;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    public VisImageTextButtonStyle getStyle() {
        return this.style;
    }

    private void updateImage() {
        Drawable drawable = null;
        if (this.isDisabled() && this.style.imageDisabled != null) {
            drawable = this.style.imageDisabled;
        } else if (this.isPressed() && this.style.imageDown != null) {
            drawable = this.style.imageDown;
        } else if (this.isChecked() && this.style.imageChecked != null) {
            drawable = this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked;
        } else if (this.isOver() && this.style.imageOver != null) {
            drawable = this.style.imageOver;
        } else if (this.style.imageUp != null) {
            drawable = this.style.imageUp;
        }
        this.image.setDrawable(drawable);
        if (this.generateDisabledImage && this.style.imageDisabled == null) {
            if (this.isDisabled()) {
                this.image.setColor(Color.GRAY);
            } else {
                this.image.setColor(Color.WHITE);
            }
        }
    }

    @Null
    protected Color getFontColor() {
        if (this.isDisabled() && this.style.disabledFontColor != null) {
            return this.style.disabledFontColor;
        }
        if (this.isPressed()) {
            if (this.isChecked() && this.style.checkedDownFontColor != null) {
                return this.style.checkedDownFontColor;
            }
            if (this.style.downFontColor != null) {
                return this.style.downFontColor;
            }
        }
        if (this.isOver()) {
            if (this.isChecked()) {
                if (this.style.checkedOverFontColor != null) {
                    return this.style.checkedOverFontColor;
                }
            } else if (this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        boolean focused = this.hasKeyboardFocus();
        if (this.isChecked()) {
            if (focused && this.style.checkedFocusedFontColor != null) {
                return this.style.checkedFocusedFontColor;
            }
            if (this.style.checkedFontColor != null) {
                return this.style.checkedFontColor;
            }
            if (this.isOver() && this.style.overFontColor != null) {
                return this.style.overFontColor;
            }
        }
        if (focused && this.style.focusedFontColor != null) {
            return this.style.focusedFontColor;
        }
        return this.style.fontColor;
    }

    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        Color fontColor = this.getFontColor();
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        super.draw(batch, parentAlpha);
        if (this.focusBorderEnabled && this.drawBorder && this.style.focusBorder != null) {
            this.style.focusBorder.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.clearChildren();
        this.addActorsBasedOnOrientation();
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell((Actor)this.image);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        return this.getCell((Actor)this.label);
    }

    public void setText(CharSequence text) {
        this.label.setText(text);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public String toString() {
        return super.toString() + ": " + this.label.getText();
    }

    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            FocusManager.resetFocus(this.getStage(), (Actor)this);
        }
    }

    @Override
    public void focusLost() {
        this.drawBorder = false;
    }

    @Override
    public void focusGained() {
        this.drawBorder = true;
    }

    @Override
    public boolean isFocusBorderEnabled() {
        return this.focusBorderEnabled;
    }

    @Override
    public void setFocusBorderEnabled(boolean focusBorderEnabled) {
        this.focusBorderEnabled = focusBorderEnabled;
    }

    public boolean isGenerateDisabledImage() {
        return this.generateDisabledImage;
    }

    public void setGenerateDisabledImage(boolean generate) {
        this.generateDisabledImage = generate;
    }

    public static class VisImageTextButtonStyle
    extends VisTextButton.VisTextButtonStyle {
        public Drawable imageUp;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;

        public VisImageTextButtonStyle() {
        }

        public VisImageTextButtonStyle(Drawable up, Drawable down, Drawable checked, BitmapFont font) {
            super(up, down, checked, font);
        }

        public VisImageTextButtonStyle(VisImageTextButtonStyle style) {
            super(style);
            if (style.imageUp != null) {
                this.imageUp = style.imageUp;
            }
            if (style.imageDown != null) {
                this.imageDown = style.imageDown;
            }
            if (style.imageOver != null) {
                this.imageOver = style.imageOver;
            }
            if (style.imageChecked != null) {
                this.imageChecked = style.imageChecked;
            }
            if (style.imageCheckedOver != null) {
                this.imageCheckedOver = style.imageCheckedOver;
            }
            if (style.imageDisabled != null) {
                this.imageDisabled = style.imageDisabled;
            }
        }

        public VisImageTextButtonStyle(VisTextButton.VisTextButtonStyle style) {
            super(style);
        }
    }

    public static enum Orientation {
        TEXT_RIGHT,
        TEXT_LEFT,
        TEXT_TOP,
        TEXT_BOTTOM;

    }
}

