/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.kotcrab.vis.ui.FocusManager;
import com.kotcrab.vis.ui.VisUI;
import com.kotcrab.vis.ui.widget.VisImageButton;

public class VisWindow
extends Window {
    public static float FADE_TIME = 0.3f;
    private boolean centerOnAdd;
    private boolean keepWithinParent = false;
    private boolean fadeOutActionRunning;

    public VisWindow(String title) {
        this(title, true);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, boolean showWindowBorder) {
        super(title, VisUI.getSkin(), showWindowBorder ? "default" : "noborder");
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, String styleName) {
        super(title, VisUI.getSkin(), styleName);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public VisWindow(String title, Window.WindowStyle style) {
        super(title, style);
        this.getTitleLabel().setAlignment(VisUI.getDefaultTitleAlign());
    }

    public void setPosition(float x, float y) {
        super.setPosition((float)((int)x), (float)((int)y));
    }

    public boolean centerWindow() {
        Group parent = this.getParent();
        if (parent == null) {
            this.centerOnAdd = true;
            return false;
        }
        this.moveToCenter();
        return true;
    }

    public void setCenterOnAdd(boolean centerOnAdd) {
        this.centerOnAdd = centerOnAdd;
    }

    protected void setStage(Stage stage) {
        super.setStage(stage);
        if (stage != null) {
            stage.setKeyboardFocus((Actor)this);
            if (this.centerOnAdd) {
                this.centerOnAdd = false;
                this.moveToCenter();
            }
        }
    }

    private void moveToCenter() {
        Stage parent = this.getStage();
        if (parent != null) {
            this.setPosition((parent.getWidth() - this.getWidth()) / 2.0f, (parent.getHeight() - this.getHeight()) / 2.0f);
        }
    }

    public void fadeOut(float time) {
        if (this.fadeOutActionRunning) {
            return;
        }
        this.fadeOutActionRunning = true;
        final Touchable previousTouchable = this.getTouchable();
        this.setTouchable(Touchable.disabled);
        Stage stage = this.getStage();
        if (stage != null && stage.getKeyboardFocus() != null && stage.getKeyboardFocus().isDescendantOf((Actor)this)) {
            FocusManager.resetFocus(stage);
        }
        this.addAction((Action)Actions.sequence((Action)Actions.fadeOut((float)time, (Interpolation)Interpolation.fade), (Action)new Action(){

            public boolean act(float delta) {
                VisWindow.this.setTouchable(previousTouchable);
                VisWindow.this.remove();
                VisWindow.this.getColor().a = 1.0f;
                VisWindow.this.fadeOutActionRunning = false;
                return true;
            }
        }));
    }

    public VisWindow fadeIn(float time) {
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.addAction((Action)Actions.fadeIn((float)time, (Interpolation)Interpolation.fade));
        return this;
    }

    public void fadeOut() {
        this.fadeOut(FADE_TIME);
    }

    public VisWindow fadeIn() {
        return this.fadeIn(FADE_TIME);
    }

    protected void close() {
        this.fadeOut();
    }

    public void addCloseButton() {
        Label titleLabel = this.getTitleLabel();
        Table titleTable = this.getTitleTable();
        VisImageButton closeButton = new VisImageButton("close-window");
        titleTable.add((Actor)closeButton).padRight(-this.getPadRight() + 0.7f);
        closeButton.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                VisWindow.this.close();
            }
        });
        closeButton.addListener((EventListener)new ClickListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                event.cancel();
                return true;
            }
        });
        if (titleLabel.getLabelAlign() == 1 && titleTable.getChildren().size == 2) {
            titleTable.getCell((Actor)titleLabel).padLeft(closeButton.getWidth() * 2.0f);
        }
    }

    public void closeOnEscape() {
        this.addListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode) {
                if (keycode == 111) {
                    VisWindow.this.close();
                    return true;
                }
                return false;
            }

            public boolean keyUp(InputEvent event, int keycode) {
                if (keycode == 4) {
                    VisWindow.this.close();
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isKeepWithinParent() {
        return this.keepWithinParent;
    }

    public void setKeepWithinParent(boolean keepWithinParent) {
        this.keepWithinParent = keepWithinParent;
    }

    public void draw(Batch batch, float parentAlpha) {
        if (this.keepWithinParent && this.getParent() != null) {
            float parentWidth = this.getParent().getWidth();
            float parentHeight = this.getParent().getHeight();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > parentWidth) {
                this.setX(parentWidth - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > parentHeight) {
                this.setY(parentHeight - this.getHeight());
            }
        }
        super.draw(batch, parentAlpha);
    }
}

