/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.color.internal;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pools;
import com.kotcrab.vis.ui.Sizes;
import com.kotcrab.vis.ui.widget.color.ColorPickerWidgetStyle;
import com.kotcrab.vis.ui.widget.color.internal.PickerCommons;
import com.kotcrab.vis.ui.widget.color.internal.ShaderImage;

public class Palette
extends ShaderImage {
    private ColorPickerWidgetStyle style;
    private Sizes sizes;
    private int xV;
    private int yS;
    private int maxValue;
    private float selectorX;
    private float selectorY;
    private float pickerHue;

    public Palette(PickerCommons commons, int maxValue, ChangeListener listener) {
        super(commons.paletteShader, commons.whiteTexture);
        this.style = commons.style;
        this.sizes = commons.sizes;
        this.maxValue = maxValue;
        this.setTouchable(Touchable.enabled);
        this.setValue(0, 0);
        this.addListener((EventListener)listener);
        this.addListener((EventListener)new InputListener(){

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                Palette.this.updateValueFromTouch(x, y);
                return true;
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                Palette.this.updateValueFromTouch(x, y);
            }
        });
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
        this.style.verticalSelector.draw(batch, this.getX(), this.getY() + this.selectorY - this.style.verticalSelector.getMinHeight() / 2.0f + 0.1f, this.getImageWidth(), this.style.verticalSelector.getMinHeight());
        this.style.horizontalSelector.draw(batch, this.getX() + this.selectorX - this.style.horizontalSelector.getMinWidth() / 2.0f + 0.1f, this.getY(), this.style.horizontalSelector.getMinWidth(), this.getImageHeight());
        this.style.cross.draw(batch, this.getX() + this.selectorX - this.style.cross.getMinWidth() / 2.0f + 0.1f, this.getY() + this.selectorY - this.style.cross.getMinHeight() / 2.0f + 0.1f, this.style.cross.getMinWidth(), this.style.cross.getMinHeight());
    }

    @Override
    protected void setShaderUniforms(ShaderProgram shader) {
        shader.setUniformf("u_h", this.pickerHue);
    }

    public void setPickerHue(int pickerHue) {
        this.pickerHue = (float)pickerHue / 360.0f;
    }

    public void setValue(int s, int v) {
        this.xV = v;
        this.yS = s;
        if (this.xV < 0) {
            this.xV = 0;
        }
        if (this.xV > this.maxValue) {
            this.xV = this.maxValue;
        }
        if (this.yS < 0) {
            this.yS = 0;
        }
        if (this.yS > this.maxValue) {
            this.yS = this.maxValue;
        }
        this.selectorX = (float)this.xV / (float)this.maxValue * 160.0f * this.sizes.scaleFactor;
        this.selectorY = (float)this.yS / (float)this.maxValue * 160.0f * this.sizes.scaleFactor;
    }

    private void updateValueFromTouch(float touchX, float touchY) {
        int newV = (int)(touchX / 160.0f * (float)this.maxValue / this.sizes.scaleFactor);
        int newS = (int)(touchY / 160.0f * (float)this.maxValue / this.sizes.scaleFactor);
        this.setValue(newS, newV);
        ChangeListener.ChangeEvent changeEvent = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent.class);
        this.fire((Event)changeEvent);
        Pools.free((Object)changeEvent);
    }

    public int getV() {
        return this.xV;
    }

    public int getS() {
        return this.yS;
    }
}

