/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.widget.file.internal;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Scaling;
import com.kotcrab.vis.ui.widget.MenuItem;
import com.kotcrab.vis.ui.widget.PopupMenu;
import com.kotcrab.vis.ui.widget.file.FileChooser;
import com.kotcrab.vis.ui.widget.file.internal.FileChooserText;

public class SortingPopupMenu
extends PopupMenu {
    private final FileChooser chooser;
    private final Drawable selectedMenuItem;
    private MenuItem sortByName;
    private MenuItem sortByDate;
    private MenuItem sortBySize;
    private MenuItem sortByAscending;
    private MenuItem sortByDescending;
    private Image sortByNameImage;
    private Image sortByDateImage;
    private Image sortBySizeImage;
    private Image sortByAscendingImage;
    private Image sortByDescendingImage;

    public SortingPopupMenu(final FileChooser chooser) {
        this.selectedMenuItem = chooser.getChooserStyle().contextMenuSelectedItem;
        this.chooser = chooser;
        this.sortByName = new MenuItem(FileChooserText.SORT_BY_NAME.get(), this.selectedMenuItem, new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.setSorting(FileChooser.FileSorting.NAME, true);
            }
        });
        this.addItem(this.sortByName);
        this.sortByDate = new MenuItem(FileChooserText.SORT_BY_DATE.get(), this.selectedMenuItem, new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.setSorting(FileChooser.FileSorting.MODIFIED_DATE, false);
            }
        });
        this.addItem(this.sortByDate);
        this.sortBySize = new MenuItem(FileChooserText.SORT_BY_SIZE.get(), this.selectedMenuItem, new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.setSorting(FileChooser.FileSorting.SIZE, true);
            }
        });
        this.addItem(this.sortBySize);
        this.addSeparator();
        this.sortByAscending = new MenuItem(FileChooserText.SORT_BY_ASCENDING.get(), this.selectedMenuItem, new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.setSortingOrderAscending(true);
            }
        });
        this.addItem(this.sortByAscending);
        this.sortByDescending = new MenuItem(FileChooserText.SORT_BY_DESCENDING.get(), this.selectedMenuItem, new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                chooser.setSortingOrderAscending(false);
            }
        });
        this.addItem(this.sortByDescending);
        this.sortByNameImage = this.sortByName.getImage();
        this.sortByDateImage = this.sortByDate.getImage();
        this.sortBySizeImage = this.sortBySize.getImage();
        this.sortByAscendingImage = this.sortByAscending.getImage();
        this.sortByDescendingImage = this.sortByDescending.getImage();
        this.sortByNameImage.setScaling(Scaling.none);
        this.sortByDateImage.setScaling(Scaling.none);
        this.sortBySizeImage.setScaling(Scaling.none);
        this.sortByAscendingImage.setScaling(Scaling.none);
        this.sortByDescendingImage.setScaling(Scaling.none);
    }

    public void build() {
        this.sortByNameImage.setDrawable(null);
        this.sortByDateImage.setDrawable(null);
        this.sortBySizeImage.setDrawable(null);
        this.sortByAscendingImage.setDrawable(null);
        this.sortByDescendingImage.setDrawable(null);
        switch (this.chooser.getSorting()) {
            case NAME: {
                this.sortByNameImage.setDrawable(this.selectedMenuItem);
                break;
            }
            case MODIFIED_DATE: {
                this.sortByDateImage.setDrawable(this.selectedMenuItem);
                break;
            }
            case SIZE: {
                this.sortBySizeImage.setDrawable(this.selectedMenuItem);
            }
        }
        if (this.chooser.isSortingOrderAscending()) {
            this.sortByAscendingImage.setDrawable(this.selectedMenuItem);
        } else {
            this.sortByDescendingImage.setDrawable(this.selectedMenuItem);
        }
    }
}

