/*
 * Decompiled with CFR 0.152.
 */
package com.hehongdan.ch34xuartdriver;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import android.widget.Toast;
import com.hehongdan.ch34xuartdriver.BytesListener;
import com.hehongdan.ch34xuartdriver.Ch34BroadcastReceiver;
import com.hehongdan.ch34xuartdriver.Ch34ReadThread;
import com.hehongdan.ch34xuartdriver.Listener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;

public class CH34xUARTDriver {
    public static final String TAG = "USB-CH34x";
    private boolean showToast = false;
    public static final int REQUEST_COUNT = 1;
    public final int _32 = 32;
    private Context context;
    private UsbManager usbManager;
    public PendingIntent pendingIntent;
    private UsbDevice usbDevice;
    private UsbInterface usbInterface;
    private UsbEndpoint usbEndpoint_e;
    private UsbEndpoint usbEndpoint_f;
    private UsbDeviceConnection usbDeviceConnection;
    private String broadcastReceiverFilter;
    private final Object writeSynchronizedObject = new Object();
    private boolean isRegisterReceiver = false;
    private boolean isNullUsb = false;
    private Ch34ReadThread readThread;
    private List<String> supportVendorProduct = new ArrayList<String>();
    private int supportTypeSize;
    private int maxPacketSize;
    private int writeTimeOut;
    private int timeOut_x = 500;
    private UsbRequest[] usbRequests = new UsbRequest[1];
    private Semaphore semaphore = new Semaphore(1);
    private final BroadcastReceiver ch34BroadcastReceiver = new Ch34BroadcastReceiver(this);
    private BytesListener readListener;
    private Listener closeListener;

    public CH34xUARTDriver(UsbManager usbManager, Context context, String filter) {
        this.usbManager = usbManager;
        this.context = context;
        this.broadcastReceiverFilter = filter;
        this.writeTimeOut = 10000;
        this.addSupportVendorProduct("1a86:7523");
        this.addSupportVendorProduct("1a86:5523");
        this.addSupportVendorProduct("1a86:5512");
    }

    public UsbDevice enumerateDevice() {
        this.usbManager = (UsbManager)this.context.getSystemService("usb");
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.broadcastReceiverFilter), (int)0);
        HashMap var1 = this.usbManager.getDeviceList();
        if (var1.isEmpty()) {
            if (this.showToast) {
                Toast.makeText((Context)this.context, (CharSequence)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match!", (int)1).show();
            } else {
                Log.d((String)TAG, (String)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match!");
            }
        } else {
            for (Object o : var1.values()) {
                UsbDevice var2 = (UsbDevice)o;
                for (int i = 0; i < this.supportTypeSize; ++i) {
                    if (!String.format("%04x:%04x", var2.getVendorId(), var2.getProductId()).equals(this.supportVendorProduct.get(i))) continue;
                    IntentFilter var5 = new IntentFilter(this.broadcastReceiverFilter);
                    var5.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.context.registerReceiver(this.ch34BroadcastReceiver, var5);
                    this.isRegisterReceiver = true;
                    return var2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice(UsbDevice usbDevice) {
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.broadcastReceiverFilter), (int)0);
        if (this.usbManager.hasPermission(usbDevice)) {
            this.connectionDevice(usbDevice);
        } else {
            BroadcastReceiver broadcastReceiver = this.ch34BroadcastReceiver;
            synchronized (broadcastReceiver) {
                this.usbManager.requestPermission(usbDevice, this.pendingIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resumeUsbList() {
        this.usbManager = (UsbManager)this.context.getSystemService("usb");
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.broadcastReceiverFilter), (int)0);
        HashMap var1 = this.usbManager.getDeviceList();
        if (var1.isEmpty()) {
            if (this.showToast) {
                Toast.makeText((Context)this.context, (CharSequence)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match", (int)1).show();
            } else {
                Log.d((String)TAG, (String)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match");
            }
        } else {
            for (Object o : var1.values()) {
                UsbDevice var2 = (UsbDevice)o;
                for (int i = 0; i < this.supportTypeSize; ++i) {
                    if (String.format("%04x:%04x", var2.getVendorId(), var2.getProductId()).equals(this.supportVendorProduct.get(i))) {
                        Log.d((String)TAG, (String)("\u6587\u672c\u683c\u5f0f\u5339\u914d-->" + String.format("%04x:%04x", var2.getVendorId(), var2.getProductId())));
                        IntentFilter var6 = new IntentFilter(this.broadcastReceiverFilter);
                        var6.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                        this.context.registerReceiver(this.ch34BroadcastReceiver, var6);
                        this.isRegisterReceiver = true;
                        if (this.usbManager.hasPermission(var2)) {
                            this.connectionDevice(var2);
                            return 0;
                        }
                        if (this.showToast) {
                            Toast.makeText((Context)this.context, (CharSequence)"\u6ca1\u6709\u6743\u9650\uff0cNo Permission!", (int)1).show();
                        } else {
                            Log.d((String)TAG, (String)"\u6ca1\u6709\u6743\u9650\uff0cNo Permission!");
                        }
                        BroadcastReceiver broadcastReceiver = this.ch34BroadcastReceiver;
                        synchronized (broadcastReceiver) {
                            this.usbManager.requestPermission(var2, this.pendingIntent);
                            return -2;
                        }
                    }
                    Log.d((String)TAG, (String)("\u6587\u672c\u683c\u5f0f\u4e0d\u5339\u914d-->" + String.format("%04x:%04x", var2.getVendorId(), var2.getProductId())));
                }
            }
        }
        return -1;
    }

    public boolean uartInit() {
        byte[] var2 = new byte[8];
        this.controlTransfer(161, 0, 0);
        if (this.controlTransfer(95, 0, 0, var2, 2) < 0) {
            return false;
        }
        this.controlTransfer(154, 4882, 55682);
        this.controlTransfer(154, 3884, 4);
        if (this.controlTransfer(149, 9496, 0, var2, 2) < 0) {
            return false;
        }
        this.controlTransfer(154, 10023, 0);
        this.controlTransfer(164, 255, 0);
        return true;
    }

    public boolean setConfig(int baudRate, byte dataBits, byte stopBits, byte parity, byte flowControl) {
        int var9;
        int var6;
        int var10;
        switch (parity) {
            case 0: {
                var10 = 0;
                break;
            }
            case 1: {
                var10 = 8;
                break;
            }
            case 2: {
                var10 = 24;
                break;
            }
            case 3: {
                var10 = 40;
                break;
            }
            case 4: {
                var10 = 56;
                break;
            }
            default: {
                var10 = 0;
            }
        }
        if (stopBits == 2) {
            var10 = (char)(var10 | 4);
        }
        switch (dataBits) {
            case 5: {
                break;
            }
            case 6: {
                var10 = (char)(var10 | 1);
                break;
            }
            case 7: {
                var10 = (char)(var10 | 2);
                break;
            }
            case 8: {
                var10 = (char)(var10 | 3);
                break;
            }
            default: {
                var10 = (char)(var10 | 3);
            }
        }
        var10 = (char)(var10 | 0xC0);
        int var7 = 0x9C | var10 << 8;
        switch (baudRate) {
            case 50: {
                var6 = 0;
                var9 = 22;
                break;
            }
            case 75: {
                var6 = 0;
                var9 = 100;
                break;
            }
            case 110: {
                var6 = 0;
                var9 = 150;
                break;
            }
            case 135: {
                var6 = 0;
                var9 = 169;
                break;
            }
            case 150: {
                var6 = 0;
                var9 = 178;
                break;
            }
            case 300: {
                var6 = 0;
                var9 = 217;
                break;
            }
            case 600: {
                var6 = 1;
                var9 = 100;
                break;
            }
            case 1200: {
                var6 = 1;
                var9 = 178;
                break;
            }
            case 1800: {
                var6 = 1;
                var9 = 204;
                break;
            }
            case 2400: {
                var6 = 1;
                var9 = 217;
                break;
            }
            case 4800: {
                var6 = 2;
                var9 = 100;
                break;
            }
            case 9600: {
                var6 = 2;
                var9 = 178;
                break;
            }
            case 19200: {
                var6 = 2;
                var9 = 217;
                break;
            }
            case 38400: {
                var6 = 3;
                var9 = 100;
                break;
            }
            case 57600: {
                var6 = 3;
                var9 = 152;
                break;
            }
            case 115200: {
                var6 = 3;
                var9 = 204;
                break;
            }
            case 230400: {
                var6 = 3;
                var9 = 230;
                break;
            }
            case 460800: {
                var6 = 3;
                var9 = 243;
                break;
            }
            case 500000: {
                var6 = 3;
                var9 = 244;
                break;
            }
            case 921600: {
                var6 = 7;
                var9 = 243;
                break;
            }
            case 1000000: {
                var6 = 3;
                var9 = 250;
                break;
            }
            case 2000000: {
                var6 = 3;
                var9 = 253;
                break;
            }
            case 3000000: {
                var6 = 3;
                var9 = 254;
                break;
            }
            default: {
                var6 = 2;
                var9 = 178;
            }
        }
        baudRate = 0x88 | var6 | var9 << 8;
        baudRate = this.controlTransfer(161, var7, baudRate);
        if (flowControl == 1) {
            int var11 = 96;
            this.controlTransfer(164, ~var11, 0);
        }
        return baudRate >= 0;
    }

    public int writeData(byte[] data, int dataLength) {
        int result = -1;
        try {
            result = this.writeData(data, dataLength, this.writeTimeOut);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.d((String)TAG, (String)("\u5199\u51fa\uff08\u53d1\u9001\uff09\u6570\u636e\u51fa\u9519=" + t.getMessage()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeData(byte[] data, int dataLength, int timeOut) throws Throwable {
        Object object = this.writeSynchronizedObject;
        synchronized (object) {
            int var5 = 0;
            int var7 = dataLength;
            if (this.usbEndpoint_f == null) {
                return -1;
            }
            while (var5 < dataLength) {
                int var15 = Math.min(var7, this.maxPacketSize);
                byte[] var8 = new byte[var15];
                if (var5 == 0) {
                    System.arraycopy(data, 0, var8, 0, var15);
                } else {
                    System.arraycopy(data, var5, var8, 0, var15);
                }
                var15 = this.usbDeviceConnection.bulkTransfer(this.usbEndpoint_f, var8, var15, timeOut);
                if (var15 < 0) {
                    return -2;
                }
                var5 += var15;
                var7 -= var15;
            }
            return var5;
        }
    }

    public void closeDevice() {
        if (this.closeListener != null) {
            Listener temp = this.closeListener;
            this.setCloseListener(null);
            temp.value();
        }
        this.setReadListener(null);
        if (this.readThread != null) {
            this.readThread.interrupt();
            this.readThread = null;
        }
        if (this.isNullUsb) {
            this.isNullUsb = false;
        }
        if (this.usbDeviceConnection != null) {
            if (this.usbInterface != null) {
                this.usbDeviceConnection.releaseInterface(this.usbInterface);
                this.usbInterface = null;
            }
            this.usbDeviceConnection.close();
        }
        if (this.usbDevice != null) {
            this.usbDevice = null;
        }
        if (this.usbManager != null) {
            this.usbManager = null;
        }
        if (this.isRegisterReceiver) {
            this.context.unregisterReceiver(this.ch34BroadcastReceiver);
            this.isRegisterReceiver = false;
        }
    }

    public boolean isConnected() {
        return this.usbDevice != null && this.usbInterface != null && this.usbDeviceConnection != null;
    }

    public void setTimeOut(int timeOut) {
        this.writeTimeOut = timeOut;
    }

    private void addSupportVendorProduct(String vendorAndProduct) {
        this.supportVendorProduct.add(vendorAndProduct);
        this.supportTypeSize = this.supportVendorProduct.size();
    }

    private void connectionDevice(UsbDevice usbDevice) {
        if (usbDevice != null) {
            UsbDeviceConnection usbDeviceConnection;
            UsbInterface usbInterface;
            if (this.usbDeviceConnection != null) {
                if (this.usbInterface != null) {
                    this.usbDeviceConnection.releaseInterface(this.usbInterface);
                    this.usbInterface = null;
                }
                this.usbDeviceConnection.close();
                this.usbDevice = null;
                this.usbInterface = null;
            }
            int USB\u63a5\u53e3\u6570\u91cf = 0;
            while (true) {
                if (USB\u63a5\u53e3\u6570\u91cf >= usbDevice.getInterfaceCount()) {
                    usbInterface = null;
                    break;
                }
                UsbInterface var5 = usbDevice.getInterface(USB\u63a5\u53e3\u6570\u91cf);
                if (var5.getInterfaceClass() == 255 && var5.getInterfaceSubclass() == 1 && var5.getInterfaceProtocol() == 2) {
                    usbInterface = var5;
                    break;
                }
                ++USB\u63a5\u53e3\u6570\u91cf;
            }
            UsbInterface usbInterface_ = usbInterface;
            if (usbInterface_ != null && (usbDeviceConnection = this.usbManager.openDevice(usbDevice)) != null && usbDeviceConnection.claimInterface(usbInterface_, true)) {
                this.usbDevice = usbDevice;
                this.usbDeviceConnection = usbDeviceConnection;
                this.usbInterface = usbInterface_;
                CH34xUARTDriver ch34xUARTDriver = this;
                for (USB\u63a5\u53e3\u6570\u91cf = 0; USB\u63a5\u53e3\u6570\u91cf < usbInterface_.getEndpointCount(); ++USB\u63a5\u53e3\u6570\u91cf) {
                    UsbEndpoint endpoint = usbInterface_.getEndpoint(USB\u63a5\u53e3\u6570\u91cf);
                    if (endpoint.getType() == 2 && endpoint.getMaxPacketSize() == 32) {
                        if (endpoint.getDirection() == 128) {
                            ch34xUARTDriver.usbEndpoint_e = endpoint;
                        } else {
                            ch34xUARTDriver.usbEndpoint_f = endpoint;
                        }
                        ch34xUARTDriver.maxPacketSize = endpoint.getMaxPacketSize();
                        continue;
                    }
                    endpoint.getType();
                }
                if (!this.isNullUsb) {
                    this.isNullUsb = true;
                    if (this.readThread != null) {
                        this.readThread.interrupt();
                    }
                    this.readThread = new Ch34ReadThread(this, this.usbEndpoint_e, this.usbDeviceConnection);
                    this.readThread.setListener(this.readListener);
                    this.readThread.start();
                }
            }
        }
    }

    public boolean usbFeatureSupported() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.usb.host");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resumeUsbPermission() {
        this.usbManager = (UsbManager)this.context.getSystemService("usb");
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.broadcastReceiverFilter), (int)0);
        HashMap var1 = this.usbManager.getDeviceList();
        if (var1.isEmpty()) {
            if (this.showToast) {
                Toast.makeText((Context)this.context, (CharSequence)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match!", (int)1).show();
            } else {
                Log.d((String)TAG, (String)"\u6ca1\u6709\u8bbe\u5907\u6216\u8bbe\u5907\u4e0d\u5339\u914d\uff0cNo Device Or Device Not Match!");
            }
        } else {
            for (Object o : var1.values()) {
                UsbDevice var2 = (UsbDevice)o;
                for (int i = 0; i < this.supportTypeSize; ++i) {
                    if (!String.format("%04x:%04x", var2.getVendorId(), var2.getProductId()).equals(this.supportVendorProduct.get(i))) continue;
                    if (!this.usbManager.hasPermission(var2)) {
                        BroadcastReceiver broadcastReceiver = this.ch34BroadcastReceiver;
                        synchronized (broadcastReceiver) {
                            this.usbManager.requestPermission(var2, this.pendingIntent);
                            return -2;
                        }
                    }
                    return 0;
                }
            }
        }
        return -1;
    }

    private int controlTransfer(int var1, int var2, int baudRate) {
        return this.usbDeviceConnection.controlTransfer(64, var1, var2, baudRate, null, 0, this.timeOut_x);
    }

    private int controlTransfer(int var1, int var2, int var3, byte[] var4, int var5) {
        return this.usbDeviceConnection.controlTransfer(192, var1, var2, 0, var4, 2, this.timeOut_x);
    }

    public UsbDeviceConnection getUsbDeviceConnection() {
        return this.usbDeviceConnection;
    }

    public UsbRequest[] getUsbRequests() {
        return this.usbRequests;
    }

    protected UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isNullUsb() {
        return this.isNullUsb;
    }

    public int getSupportTypeSize() {
        return this.supportTypeSize;
    }

    public List<String> getSupportVendorProduct() {
        return this.supportVendorProduct;
    }

    public String getBroadcastReceiverFilter() {
        return this.broadcastReceiverFilter == null ? "" : this.broadcastReceiverFilter;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public boolean isShowToast() {
        return this.showToast;
    }

    public void setShowToast(boolean showToast) {
        this.showToast = showToast;
    }

    public void setReadListener(BytesListener readListener) {
        if (this.readThread != null) {
            this.readThread.setListener(readListener);
        }
        this.readListener = readListener;
    }

    public void setCloseListener(Listener closeListener) {
        this.closeListener = closeListener;
    }
}

