/*
 * Decompiled with CFR 0.152.
 */
package com.hehongdan.ch34xuartdriver;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.hehongdan.ch34xuartdriver.BytesListener;
import com.hehongdan.ch34xuartdriver.CH34xUARTDriver;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Ch34ReadThread
extends Thread {
    private CH34xUARTDriver ch34xUARTDriver;
    private UsbEndpoint usbEndpoint;
    private UsbDeviceConnection usbDeviceConnection;
    private ByteBuffer[] byteBuffers = new ByteBuffer[1];
    private BytesListener listener;

    public Ch34ReadThread(CH34xUARTDriver driver, UsbEndpoint endpoint, UsbDeviceConnection deviceConnection) {
        this.ch34xUARTDriver = driver;
        this.usbEndpoint = endpoint;
        this.usbDeviceConnection = deviceConnection;
        for (int i = 0; i < 1; ++i) {
            driver.getUsbRequests()[i] = new UsbRequest();
            driver.getUsbRequests()[i].initialize(this.usbDeviceConnection, this.usbEndpoint);
            this.byteBuffers[i] = ByteBuffer.allocate(this.ch34xUARTDriver._32);
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        super.run();
        for (int i = 0; i < this.byteBuffers.length; ++i) {
            this.ch34xUARTDriver.getUsbRequests()[i].queue(this.byteBuffers[i], this.ch34xUARTDriver._32);
        }
        int count = 0;
        block3: while (!Thread.interrupted()) {
            while (this.ch34xUARTDriver.isNullUsb() && this.usbEndpoint == null && !Thread.interrupted()) {
            }
            for (int i = 0; i < this.byteBuffers.length; ++i) {
                UsbRequest usbRequest = this.usbDeviceConnection.requestWait();
                if (!this.ch34xUARTDriver.isNullUsb() && count++ > this.byteBuffers.length) {
                    Log.v((String)"USB-CH34x", (String)"USB\u5df2\u7ecf\u5173\u95ed");
                    break block3;
                }
                if (usbRequest == null) continue block3;
                UsbRequest usbRequestI = this.ch34xUARTDriver.getUsbRequests()[i];
                if (usbRequest != usbRequestI) continue;
                count = 0;
                byte[] \u7f13\u51b2\u533a = this.byteBuffers[i].array();
                int \u7f13\u51b2\u533a_\u957f\u5ea6 = this.byteBuffers[i].position();
                if (\u7f13\u51b2\u533a_\u957f\u5ea6 > 0) {
                    try {
                        this.ch34xUARTDriver.getSemaphore().acquire();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    byte[] bytes = Arrays.copyOf(\u7f13\u51b2\u533a, \u7f13\u51b2\u533a_\u957f\u5ea6);
                    if (this.listener != null) {
                        this.listener.value(bytes);
                    }
                    this.ch34xUARTDriver.getSemaphore().release();
                }
                this.ch34xUARTDriver.getUsbRequests()[i].queue(this.byteBuffers[i], this.ch34xUARTDriver._32);
            }
        }
        for (ByteBuffer byteBuffer : this.byteBuffers) {
            byteBuffer.clear();
        }
        Log.v((String)"USB-CH34x", (String)"\u9000\u51fa\u8bfb\u53d6\u7ebf\u7a0b");
    }

    public void setListener(BytesListener listener) {
        this.listener = listener;
    }
}

