/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisTransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpApiTransport
extends Transport {
    public static final int DEFAULT_MAX_CONNECTIONS = 256;
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT_MINUTES = 1;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final String CUSTOM_HEADER_MERCHANT_ID = "X-Kount-Merc-Id";
    public static final String CUSTOM_HEADER_API_KEY = "X-Kount-Api-Key";
    private static final Logger logger = LogManager.getLogger(HttpApiTransport.class);
    private static final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    protected String apiKey;
    private CloseableHttpClient httpClient;
    private int connectionTimeToLive;

    public HttpApiTransport() {
        this.connectTimeout = 10000;
        this.readTimeout = 10000;
        this.connectionTimeToLive = 1;
    }

    public HttpApiTransport(URL url, String key) {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
    }

    public HttpApiTransport(URL url, String key, int maxConnections, int maxConnectionsPerRoute) {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
        connManager.setMaxTotal(maxConnections);
        connManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public void setConnectionTimeToLive(int minutes) {
        this.connectionTimeToLive = minutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpApiTransport httpApiTransport = this;
            synchronized (httpApiTransport) {
                if (this.httpClient == null) {
                    this.httpClient = HttpClients.custom().setConnectionTimeToLive((long)this.connectionTimeToLive, TimeUnit.MINUTES).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.readTimeout).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).setCookieSpec("standard-strict").build()).setConnectionManager((HttpClientConnectionManager)connManager).build();
                }
            }
        }
        return this.httpClient;
    }

    @Override
    public Reader send(Map<String, String> params) throws RisTransportException {
        if (!params.containsKey("PTOK") || "KHASH".equals(params.get("PENC")) && null == params.get("PTOK")) {
            params.put("PENC", "");
        }
        InputStreamReader reader = null;
        try {
            long startTime = System.currentTimeMillis();
            HttpPost httpPost = new HttpPost(this.risServerUrl);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.addHeader(CUSTOM_HEADER_API_KEY, this.apiKey);
            httpPost.addHeader(CUSTOM_HEADER_MERCHANT_ID, params.get("MERC"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(this.convertToNameValuePair(params)));
            try (CloseableHttpResponse httpResponse = this.getHttpClient().execute((HttpUriRequest)httpPost);){
                reader = new InputStreamReader(this.readAllIntput(httpResponse.getEntity()));
                if (logger.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    StringBuilder builder = new StringBuilder();
                    builder.append("MERC = ").append(params.get("MERC"));
                    builder.append(" SESS = ").append(params.get("SESS"));
                    builder.append(" elapsed = ").append(elapsed).append(" ms.");
                    logger.debug(builder.toString());
                }
            }
        }
        catch (Exception ioe) {
            logger.error("Error fetching RIS response", (Throwable)ioe);
            throw new RisTransportException("An error occurred while getting the RIS response", ioe);
        }
        return reader;
    }

    public ByteArrayInputStream readAllIntput(HttpEntity entity) throws IOException {
        try {
            int nRead;
            InputStream is = entity.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    static {
        connManager.setMaxTotal(256);
        connManager.setDefaultMaxPerRoute(256);
    }
}

