/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisTransportException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KountHttpTransport
extends Transport {
    private static final Logger logger = LogManager.getLogger(KountHttpTransport.class);
    protected SSLSocketFactory factory;
    protected char[] privateKeyPassphrase;
    protected InputStream pkcs12In;
    protected String pkcs12file;
    protected String algorithm = "SunX509";

    public KountHttpTransport() {
    }

    public KountHttpTransport(String phrase, String url, String p12file) {
        this.setPassPhrase(phrase);
        this.risServerUrl = url;
        this.pkcs12file = p12file;
    }

    public KountHttpTransport(String phrase, String url, InputStream p12in) {
        this.setPassPhrase(phrase);
        this.risServerUrl = url;
        this.pkcs12In = p12in;
    }

    public void setPassPhrase(String p) {
        this.privateKeyPassphrase = p.toCharArray();
    }

    public void setAlgorithm(String a) {
        this.algorithm = a;
    }

    @Override
    public Reader send(Map<String, String> params) throws RisTransportException {
        if (!params.containsKey("PTOK") || params.containsKey("PENC") && "KHASH".equals(params.get("PENC")) && null == params.get("PTOK")) {
            params.put("PENC", "");
        }
        BufferedReader reader = null;
        try {
            URL url = new URL(this.risServerUrl);
            HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setSSLSocketFactory(this.getSSLSocketFactory());
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConn.setConnectTimeout(this.connectTimeout);
            urlConn.setReadTimeout(this.readTimeout);
            OutputStreamWriter out = new OutputStreamWriter(urlConn.getOutputStream(), "UTF-8");
            KountHttpTransport.writeParametersToOutput(out, params);
            out.flush();
            out.close();
            reader = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        }
        catch (IOException ioe) {
            logger.error("Error fetching RIS response", (Throwable)ioe);
            throw new RisTransportException("An error ocurred while getting the RIS response", ioe);
        }
        return reader;
    }

    protected SSLSocketFactory getSSLSocketFactory() throws RisTransportException {
        SSLContext ctx;
        KeyManagerFactory keyFact;
        KeyStore store;
        if (null != this.factory) {
            return this.factory;
        }
        try {
            store = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException kse) {
            logger.error("Error creating keystore of type PKCS12", (Throwable)kse);
            throw new RisTransportException("Unable to create KeyStore of type PKCS12", kse);
        }
        try {
            InputStream pkIn = this.getPkcs12Data();
            store.load(pkIn, this.privateKeyPassphrase);
            pkIn.close();
        }
        catch (IOException ioe) {
            logger.error("Unable to read PKCS12 data", (Throwable)ioe);
            throw new RisTransportException("Unable to read PKCS12 data", ioe);
        }
        catch (CertificateException ce) {
            logger.error("Unable to read PKCS12 data" + ce);
            throw new RisTransportException("Unable to read PKCS12 data", ce);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Unable to read PKCS12 data", (Throwable)nsae);
            throw new RisTransportException("Unable to read PKCS12 data", nsae);
        }
        try {
            keyFact = KeyManagerFactory.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Unable to create a KeyManagerFactory of type: " + this.algorithm, (Throwable)nsae);
            throw new RisTransportException("Unable to create a KeyManagerFactory of type " + this.algorithm, nsae);
        }
        try {
            keyFact.init(store, this.privateKeyPassphrase);
        }
        catch (UnrecoverableKeyException uke) {
            logger.error("Private key passphrase is incorrect for PKCS12 data", (Throwable)uke);
            throw new RisTransportException("Private key passphrase is incorrect for PKCS12 data", uke);
        }
        catch (KeyStoreException kse) {
            logger.error("Unable to initialize KeyManagerFactory", (Throwable)kse);
            throw new RisTransportException("Unable to initialize KeyManagerFactory", kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("PKCS12 is not supported in the current environment", (Throwable)nsae);
            throw new RisTransportException("PKCS12 is not supported in the current environment", nsae);
        }
        try {
            ctx = SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Unable to create SSLContext of type TLS", (Throwable)nsae);
            throw new RisTransportException("Unable to create SSLContext of type TLS", nsae);
        }
        try {
            ctx.init(keyFact.getKeyManagers(), null, null);
        }
        catch (KeyManagementException kme) {
            logger.error("Unable to initialize SSLContext", (Throwable)kme);
            throw new RisTransportException("Unable to initialize SSLContext", kme);
        }
        this.factory = ctx.getSocketFactory();
        return this.factory;
    }

    protected InputStream getPkcs12Data() throws RisTransportException {
        if (null == this.pkcs12In) {
            String fileName = this.pkcs12file;
            try {
                this.pkcs12In = new FileInputStream(fileName);
            }
            catch (FileNotFoundException fnfe) {
                logger.error("PKCS12 file specified as " + fileName + " could not be found", (Throwable)fnfe);
                throw new RisTransportException("PKCS12 file specified as " + fileName + " could not be found", fnfe);
            }
        }
        return this.pkcs12In;
    }
}

