/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;

public final class RsaUtil {
    public static final String CIPHER_INSTANCE = "RSA";
    public static final String CIPHER_STRING = "RSA/ECB/PKCS1Padding";
    private static RsaUtil rsaUtil;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private final String rsaKey = "-----BEGIN PUBLIC KEY-----\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAwyC+qwP7LEA/MFRp3d4p\nqNMEPavUIjMcKvUbfa9HaGmZuslPT9BY4cO18mrHTIoMOpazB0bN1ImYjagJitq9\nv0PLupIocFBEHVL8d+4G7anyiLQYMgztRv12VKbGXNmEZdu9VqptlXoOGvpMSVc0\n6zcwY4u9GaC+poa0AVX2iIzKsvzaNImHI4/QxJ7gm3QV1rEDcIeVT/GQc/YYVfwn\nhrGAazrao1KspBZQ5OEdeI7gMlVyiwiULhZDlePKY0nzmWZZkxBQ6m2OhFlaOHMR\nxbaKt14KN/DJ3U4F7+557j0cHYfxC79m7eTcEqgbXITHwVHMrqr/nd3Fdps+jp5G\nwqiRTDLpQXQEDSXdReZnjEyAGEbB4kPkvENyrfwNF7InGn8ilFUMCq1OTGqRwr7J\nTXhvefGPmtgFYLYsYhc2nauizjm7A6bvCSNB33PVTahAbPRw3ADw2H5tDbW9+VYt\nfoMhagbzUyqHazNwbi3Zv7RuRZxXwpBtFZissdUJRvv5+n6LLz5HWQF5YpUELzLt\naMJKwd8IoKXqMCaoLl0t2raNpMt+MH5o1TZjKH/LCI3DDNUTkVVKeIZQoylIGsxO\n+diE0Vn//pp137Ar6hWjhGQY8JjNX0KOIJxghl1/sd98Ec+VcdtW6dBQISI5aTTG\nsV+/iOvXHcHjxILT9riYCD0CAwEAAQ==\n-----END PUBLIC KEY-----";

    private RsaUtil() {
    }

    public static synchronized RsaUtil getInstance() {
        if (rsaUtil == null) {
            rsaUtil = new RsaUtil();
        }
        return rsaUtil;
    }

    public byte[] encrypt(String payload) throws IOException, GeneralSecurityException {
        return this.encrypt(null, payload);
    }

    public byte[] encrypt(String publicKeyFileName, String payload) throws IOException, GeneralSecurityException {
        this.publicKey = this.readPublicKeyFromFile(publicKeyFileName);
        Cipher c = Cipher.getInstance(CIPHER_STRING);
        c.init(1, this.publicKey);
        return c.doFinal(payload.getBytes());
    }

    public byte[] decrypt(String privateKeyFileName, byte[] payload) throws IOException, GeneralSecurityException {
        if (this.privateKey == null) {
            this.privateKey = this.readPrivateKeyFromFile(privateKeyFileName);
        }
        Cipher c = Cipher.getInstance(CIPHER_STRING);
        c.init(2, this.privateKey);
        return c.doFinal(payload);
    }

    private PublicKey readPublicKeyFromFile(String publicKeyFilename) throws IOException, GeneralSecurityException {
        if (this.publicKey == null) {
            byte[] fileData = publicKeyFilename == null ? this.scrubKey("-----BEGIN PUBLIC KEY-----\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAwyC+qwP7LEA/MFRp3d4p\nqNMEPavUIjMcKvUbfa9HaGmZuslPT9BY4cO18mrHTIoMOpazB0bN1ImYjagJitq9\nv0PLupIocFBEHVL8d+4G7anyiLQYMgztRv12VKbGXNmEZdu9VqptlXoOGvpMSVc0\n6zcwY4u9GaC+poa0AVX2iIzKsvzaNImHI4/QxJ7gm3QV1rEDcIeVT/GQc/YYVfwn\nhrGAazrao1KspBZQ5OEdeI7gMlVyiwiULhZDlePKY0nzmWZZkxBQ6m2OhFlaOHMR\nxbaKt14KN/DJ3U4F7+557j0cHYfxC79m7eTcEqgbXITHwVHMrqr/nd3Fdps+jp5G\nwqiRTDLpQXQEDSXdReZnjEyAGEbB4kPkvENyrfwNF7InGn8ilFUMCq1OTGqRwr7J\nTXhvefGPmtgFYLYsYhc2nauizjm7A6bvCSNB33PVTahAbPRw3ADw2H5tDbW9+VYt\nfoMhagbzUyqHazNwbi3Zv7RuRZxXwpBtFZissdUJRvv5+n6LLz5HWQF5YpUELzLt\naMJKwd8IoKXqMCaoLl0t2raNpMt+MH5o1TZjKH/LCI3DDNUTkVVKeIZQoylIGsxO\n+diE0Vn//pp137Ar6hWjhGQY8JjNX0KOIJxghl1/sd98Ec+VcdtW6dBQISI5aTTG\nsV+/iOvXHcHjxILT9riYCD0CAwEAAQ==\n-----END PUBLIC KEY-----") : this.readFile(publicKeyFilename);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(fileData);
            KeyFactory fac = KeyFactory.getInstance(CIPHER_INSTANCE);
            this.publicKey = fac.generatePublic(keySpec);
        }
        return this.publicKey;
    }

    private PrivateKey readPrivateKeyFromFile(String privateKeyFilename) throws IOException, GeneralSecurityException {
        if (this.privateKey == null) {
            byte[] fileData = this.readFile(privateKeyFilename);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(fileData);
            KeyFactory fac = KeyFactory.getInstance(CIPHER_INSTANCE);
            this.privateKey = fac.generatePrivate(keySpec);
        }
        return this.privateKey;
    }

    private byte[] readFile(String filename) throws IOException {
        byte[] fileBytes = Files.readAllBytes(Paths.get(filename, new String[0]));
        String fileContents = new String(fileBytes, Charset.forName("UTF-8"));
        return this.scrubKey(fileContents.trim());
    }

    private byte[] scrubKey(String key) {
        key = key.replaceAll("(-.+[BE].+-)", "");
        return DatatypeConverter.parseBase64Binary((String)key);
    }
}

