/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris;

import com.kount.ris.Request;
import com.kount.ris.util.Address;
import com.kount.ris.util.CartItem;
import com.kount.ris.util.CurrencyType;
import com.kount.ris.util.InquiryMode;
import com.kount.ris.util.ShippingType;
import java.util.Collection;
import java.util.Iterator;

public class Inquiry
extends Request {
    public Inquiry() {
        this.setMode(InquiryMode.INITIAL_INQUIRY);
        this.setCurrency("USD");
        this.params.put("SDK_VERSION", "Sdk-Ris-" + Inquiry.config.SDK + "-" + Inquiry.config.SDK_VERSION);
    }

    public Inquiry setCash(long cash) {
        this.params.put("CASH", String.valueOf(cash));
        return this;
    }

    public Inquiry setDateOfBirth(String dob) {
        this.params.put("DOB", dob);
        return this;
    }

    public Inquiry setGender(char gender) {
        this.params.put("GENDER", Character.toString(gender));
        return this;
    }

    public Inquiry setUserDefinedField(String label, String value) {
        this.params.put("UDF[" + label + "]", value);
        return this;
    }

    public Inquiry setMode(InquiryMode mode) {
        this.params.put("MODE", mode.toString());
        return this;
    }

    public Inquiry setCurrency(CurrencyType currency) {
        this.logger.info("The method com.kount.ris.Inquiry.setCurrency(CurrencyType) : Inquiry is deprecated. Use com.kount.ris.Inquiry.setCurrency(String) : Inquiry instead.");
        this.params.put("CURR", currency.toString());
        return this;
    }

    public Inquiry setCurrency(String currency) {
        this.params.put("CURR", currency);
        return this;
    }

    public Inquiry setTotal(long total) {
        this.params.put("TOTL", String.valueOf(total));
        return this;
    }

    public Inquiry setEmail(String email) {
        this.params.put("EMAL", email);
        return this;
    }

    public Inquiry setCustomerName(String customerName) {
        this.params.put("NAME", customerName);
        return this;
    }

    public Inquiry setBillingAddress(Address address) {
        this.params.put("B2A1", address.getAddress1());
        this.params.put("B2A2", address.getAddress2());
        this.params.put("B2CI", address.getCity());
        this.params.put("B2ST", address.getState());
        this.params.put("B2PC", address.getPostalCode());
        this.params.put("B2CC", address.getCountry());
        this.params.put("BPREMISE", address.getPremise());
        this.params.put("BSTREET", address.getStreet());
        return this;
    }

    public Inquiry setShippingAddress(Address address) {
        this.params.put("S2A1", address.getAddress1());
        this.params.put("S2A2", address.getAddress2());
        this.params.put("S2CI", address.getCity());
        this.params.put("S2ST", address.getState());
        this.params.put("S2PC", address.getPostalCode());
        this.params.put("S2CC", address.getCountry());
        this.params.put("SPREMISE", address.getPremise());
        this.params.put("SSTREET", address.getStreet());
        return this;
    }

    public Inquiry setBillingPhoneNumber(String billingPhoneNumber) {
        this.params.put("B2PN", billingPhoneNumber);
        return this;
    }

    public Inquiry setShippingPhoneNumber(String shippingPhoneNumber) {
        this.params.put("S2PN", shippingPhoneNumber);
        return this;
    }

    public Inquiry setShippingName(String shippingName) {
        this.params.put("S2NM", shippingName);
        return this;
    }

    public Inquiry setShippingEmail(String shippingEmail) {
        this.params.put("S2EM", shippingEmail);
        return this;
    }

    public Inquiry setUniqueCustomerId(String uniqueCustomerId) {
        this.params.put("UNIQ", uniqueCustomerId);
        return this;
    }

    public Inquiry setIpAddress(String ipAddress) {
        this.params.put("IPAD", ipAddress);
        return this;
    }

    public Inquiry setUserAgent(String userAgent) {
        this.params.put("UAGT", userAgent);
        return this;
    }

    public Inquiry setEpoch(long timeStamp) {
        this.params.put("EPOC", String.valueOf(timeStamp));
        return this;
    }

    public Inquiry setShippingType(ShippingType shippingType) {
        this.params.put("SHTP", shippingType.toString());
        return this;
    }

    public Inquiry setAnid(String anid) {
        this.params.put("ANID", anid);
        return this;
    }

    public Inquiry setName(String name) {
        this.params.put("NAME", name);
        return this;
    }

    public Inquiry setWebsite(String site) {
        this.params.put("SITE", site);
        return this;
    }

    public Inquiry setCart(Collection<CartItem> cart) {
        Iterator<CartItem> itr = cart.iterator();
        int index = 0;
        while (itr.hasNext()) {
            CartItem item = itr.next();
            this.params.put("PROD_TYPE[" + index + "]", item.getProductType());
            this.params.put("PROD_ITEM[" + index + "]", item.getItemName());
            this.params.put("PROD_DESC[" + index + "]", item.getDescription());
            this.params.put("PROD_QUANT[" + index + "]", new Integer(item.getQuantity()).toString());
            this.params.put("PROD_PRICE[" + index + "]", new Integer(item.getPrice()).toString());
            ++index;
        }
        return this;
    }
}

