/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris;

import com.kount.ris.Request;
import com.kount.ris.Response;
import com.kount.ris.transport.HttpApiTransport;
import com.kount.ris.transport.KountHttpTransport;
import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisException;
import com.kount.ris.util.RisResponseException;
import com.kount.ris.util.RisTransportException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KountRisClient {
    private static final Logger logger = LogManager.getLogger(KountRisClient.class);
    protected Transport transport;
    protected StringBuilder errorMessage = null;
    protected String apiKey;

    public KountRisClient() {
    }

    public KountRisClient(String phrase, String url, String p12file) {
        logger.debug("RIS endpoint URL [" + url + "]");
        this.transport = new KountHttpTransport(phrase, url, p12file);
    }

    public KountRisClient(String phrase, String url, InputStream p12in) {
        this.transport = new KountHttpTransport(phrase, url, p12in);
    }

    public KountRisClient(URL url, File apiKeyFile) throws RisTransportException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey);
    }

    public KountRisClient(URL url, File apiKeyFile, int connectionPoolThreads, int connectionPerRoute) throws RisTransportException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute);
    }

    public KountRisClient(URL url, String key) {
        this.setApiKey(key);
        this.transport = new HttpApiTransport(url, this.apiKey);
    }

    public KountRisClient(URL url, String key, int connectionPoolThreads, int connectionPerRoute) {
        this.setApiKey(key);
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute);
    }

    public void setTransport(Transport t) {
        this.transport = t;
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public Response process(Request r) throws RisException {
        logger.trace("process()");
        if (this.transport != null) {
            return this.transport.sendResponse(r.getParams());
        }
        throw new RisTransportException("No transport was specified, unable to send request.");
    }

    protected Response parse(Reader r) throws RisResponseException {
        logger.trace("parse()");
        return Response.parseResponse(r);
    }

    protected final String getApiKey(File apiKeyFile) throws RisTransportException {
        logger.trace("getApiKey()");
        if (this.apiKey == null && apiKeyFile != null) {
            try {
                byte[] keyBytes = Files.readAllBytes(Paths.get(apiKeyFile.toURI()));
                String key = new String(keyBytes, Charset.forName("UTF-8"));
                this.setApiKey(key.trim());
            }
            catch (IOException e) {
                logger.error("API Key file (" + apiKeyFile + ") could not be found:\n" + e);
                throw new RisTransportException("API Key file (" + apiKeyFile + ") could not be found:\n" + e);
            }
        }
        return this.apiKey;
    }
}

