/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.kount.ris.Response;
import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisResponseException;
import com.kount.ris.util.RisTransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpApiTransport
extends Transport {
    public static final int DEFAULT_MAX_CONNECTIONS = 256;
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT_MINUTES = 1;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final String CUSTOM_HEADER_MERCHANT_ID = "X-Kount-Merc-Id";
    public static final String CUSTOM_HEADER_API_KEY = "X-Kount-Api-Key";
    private static final Logger logger = LogManager.getLogger(HttpApiTransport.class);
    private static final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    protected String apiKey;
    private CloseableHttpClient httpClient;
    private int connectionTimeToLive;

    public HttpApiTransport() {
        this.connectTimeout = 10000;
        this.readTimeout = 10000;
        this.connectionTimeToLive = 1;
    }

    public HttpApiTransport(URL url, String key) {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
    }

    public HttpApiTransport(URL url, String key, int maxConnections, int maxConnectionsPerRoute) {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
        connManager.setMaxTotal(maxConnections);
        connManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public void setConnectionTimeToLive(int minutes) {
        this.connectionTimeToLive = minutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpApiTransport httpApiTransport = this;
            synchronized (httpApiTransport) {
                this.httpClient = HttpClients.custom().useSystemProperties().setConnectionTimeToLive((long)this.connectionTimeToLive, TimeUnit.MINUTES).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.readTimeout).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).setCookieSpec("standard-strict").build()).setConnectionManager((HttpClientConnectionManager)connManager).setKeepAliveStrategy(this.getKeepAliveStrategy()).build();
            }
        }
        return this.httpClient;
    }

    private ConnectionKeepAliveStrategy getKeepAliveStrategy() {
        ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return 5000L;
            }
        };
        return keepAliveStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream readAllIntput(HttpEntity entity) throws IOException {
        try {
            int nRead;
            InputStream is = entity.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Response sendResponse(Map<String, String> params) throws RisTransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Response parse(Reader r) throws RisResponseException {
        logger.trace("parse()");
        return Response.parseResponse(r);
    }

    static {
        connManager.setMaxTotal(256);
        connManager.setDefaultMaxPerRoute(256);
    }
}

