/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kount.ris.Response;
import com.kount.ris.transport.BearerAuthResponse;
import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisResponseException;
import com.kount.ris.util.RisTransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.ConfigurationException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpApiTransport
extends Transport {
    public static final int DEFAULT_MAX_CONNECTIONS = 256;
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT_MINUTES = 1;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final String CUSTOM_HEADER_MERCHANT_ID = "X-Kount-Merc-Id";
    public static final String CUSTOM_HEADER_API_KEY = "X-Kount-Api-Key";
    public static final String PF_AUTH_HEADER = "Authorization";
    private static final Logger logger = LogManager.getLogger(HttpApiTransport.class);
    private static final PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMinutes((long)1L)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.FIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMilliseconds((long)10000L)).setConnectTimeout(Timeout.ofMilliseconds((long)10000L)).setTimeToLive(TimeValue.ofMinutes((long)1L)).build()).build();
    protected String apiKey;
    private CloseableHttpClient httpClient;
    private static boolean migrationModeEnabled;
    private static boolean initialized;
    private static String paymentsFraudApiEndpoint;
    private static String paymentsFraudAuthEndpoint;
    private static String paymentsFraudClientId;
    private static String paymentsFraudApiKey;
    private static BearerAuthResponse bearer;
    private static final ReentrantReadWriteLock bearerRWLock;
    private static final Lock bearerReadLock;
    private static final Lock bearerWriteLock;
    private int connectionTimeToLive;

    public HttpApiTransport() throws ConfigurationException {
        this.connectTimeout = 10000;
        this.readTimeout = 10000;
        this.connectionTimeToLive = 1;
        this.checkMigrationMode();
    }

    public HttpApiTransport(URL url, String key) throws ConfigurationException {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
        this.checkMigrationMode();
    }

    public HttpApiTransport(URL url, String key, int maxConnections, int maxConnectionsPerRoute) throws ConfigurationException {
        this();
        this.setRisServerUrl(url.toString());
        this.setApiKey(key);
        connManager.setMaxTotal(maxConnections);
        connManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        this.checkMigrationMode();
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public void setConnectionTimeToLive(int minutes) {
        this.connectionTimeToLive = minutes;
    }

    private void checkMigrationMode() throws ConfigurationException {
        String migrationModeStr = System.getProperty("migration.mode.enabled", "false");
        migrationModeEnabled = Boolean.parseBoolean(migrationModeStr);
        if (migrationModeEnabled && !initialized) {
            paymentsFraudApiEndpoint = System.getProperty("payments.fraud.api.endpoint", "");
            if (Objects.equals(paymentsFraudApiEndpoint, "")) {
                throw new ConfigurationException("Migration mode is enabled but 'payments.fraud.api.endpoint' is not configured");
            }
            paymentsFraudAuthEndpoint = System.getProperty("payments.fraud.auth.endpoint", "");
            if (Objects.equals(paymentsFraudAuthEndpoint, "")) {
                throw new ConfigurationException("Migration mode is enabled but 'payments.fraud.auth.endpoint' is not configured");
            }
            paymentsFraudClientId = System.getProperty("payments.fraud.client.id", "");
            if (Objects.equals(paymentsFraudClientId, "")) {
                throw new ConfigurationException("Migration mode is enabled but 'payments.fraud.client.id' is not configured");
            }
            paymentsFraudApiKey = System.getProperty("payments.fraud.api.key", "");
            if (Objects.equals(paymentsFraudApiKey, "")) {
                throw new ConfigurationException("Migration mode is enabled but 'payments.fraud.api.key' is not configured");
            }
            initialized = true;
        }
    }

    private static void refreshAuthToken() throws RisTransportException {
        block17: {
            bearerWriteLock.lock();
            if (HttpApiTransport.bearer.expiresAt.isAfter(OffsetDateTime.now().plusSeconds(60L))) {
                return;
            }
            try {
                HttpPost httpPost = new HttpPost(paymentsFraudAuthEndpoint);
                httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                httpPost.addHeader(PF_AUTH_HEADER, (Object)("Basic " + paymentsFraudApiKey));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("grant_type", "client_credentials");
                params.put("scope", "k1_integration_api");
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpApiTransport.convertToNameValuePair(params)));
                CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
                try (CloseableHttpResponse httpResponse = (CloseableHttpResponse)httpClient.execute((ClassicHttpRequest)httpPost);
                     InputStreamReader reader = new InputStreamReader(HttpApiTransport.readAllInput(httpResponse.getEntity()));){
                    if (httpResponse.getCode() < 400) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        BearerAuthResponse authResponse = new BearerAuthResponse();
                        authResponse = (BearerAuthResponse)objectMapper.readValue((Reader)reader, BearerAuthResponse.class);
                        if (!authResponse.createdAt.equals(authResponse.expiresAt) && authResponse.expiresAt.isAfter(HttpApiTransport.bearer.expiresAt)) {
                            bearerReadLock.lock();
                            bearer = authResponse;
                            bearerReadLock.unlock();
                        } else {
                            logger.warn("new auth token expires before existing one, keeping existing one");
                        }
                        break block17;
                    }
                    bearerWriteLock.unlock();
                    String message = "Error fetching auth token: received " + httpResponse.getCode() + " " + httpResponse.getReasonPhrase();
                    logger.error(message);
                    throw new RisTransportException("An error occurred while reading the auth token response: " + message);
                }
            }
            catch (Exception ioe) {
                bearerWriteLock.unlock();
                logger.error("Error fetching updating bearer auth token", (Throwable)ioe);
                throw new RisTransportException("An error occurred while getting the auth token", ioe);
            }
        }
        bearerWriteLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpApiTransport httpApiTransport = this;
            synchronized (httpApiTransport) {
                this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
            }
        }
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayInputStream readAllInput(HttpEntity entity) throws IOException {
        try {
            int nRead;
            InputStream is = entity.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response sendResponse(Map<String, String> params) throws RisTransportException {
        if (!params.containsKey("PTOK") || "KHASH".equals(params.get("PENC")) && null == params.get("PTOK")) {
            params.put("PENC", "");
        }
        try {
            HttpPost httpPost;
            if (migrationModeEnabled && HttpApiTransport.bearer.expiresAt.isBefore(OffsetDateTime.now().plusSeconds(60L))) {
                HttpApiTransport.refreshAuthToken();
            }
            long startTime = System.currentTimeMillis();
            if (migrationModeEnabled) {
                httpPost = new HttpPost(paymentsFraudApiEndpoint);
                bearerReadLock.lock();
                httpPost.addHeader(PF_AUTH_HEADER, (Object)(HttpApiTransport.bearer.tokenType + " " + HttpApiTransport.bearer.accessToken));
                bearerReadLock.unlock();
                params.put("MERC", paymentsFraudClientId);
                httpPost.addHeader(CUSTOM_HEADER_MERCHANT_ID, (Object)paymentsFraudClientId);
            } else {
                httpPost = new HttpPost(this.risServerUrl);
                httpPost.addHeader(CUSTOM_HEADER_API_KEY, (Object)this.apiKey);
                httpPost.addHeader(CUSTOM_HEADER_MERCHANT_ID, (Object)params.get("MERC"));
            }
            httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpApiTransport.convertToNameValuePair(params)));
            try (CloseableHttpResponse httpResponse = this.getHttpClient().execute((ClassicHttpRequest)httpPost);){
                Response response;
                try (InputStreamReader reader = new InputStreamReader(HttpApiTransport.readAllInput(httpResponse.getEntity()));){
                    Response responseObj = this.parse(reader);
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException e) {
                        throw new RisTransportException("Error closing reader", e);
                    }
                    response = responseObj;
                }
                return response;
            }
        }
        catch (Exception ioe) {
            logger.error("Error fetching RIS response", (Throwable)ioe);
            throw new RisTransportException("An error occurred while getting the RIS response", ioe);
        }
    }

    protected Response parse(Reader r) throws RisResponseException {
        logger.trace("parse()");
        return Response.parseResponse(r);
    }

    static {
        connManager.setMaxTotal(256);
        connManager.setDefaultMaxPerRoute(256);
        migrationModeEnabled = false;
        initialized = false;
        paymentsFraudApiEndpoint = "";
        paymentsFraudAuthEndpoint = "";
        paymentsFraudClientId = "";
        paymentsFraudApiKey = "";
        bearer = new BearerAuthResponse();
        bearerRWLock = new ReentrantReadWriteLock();
        bearerReadLock = bearerRWLock.readLock();
        bearerWriteLock = bearerRWLock.writeLock();
    }
}

