/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris;

import com.kount.ris.util.KcEvent;
import com.kount.ris.util.RisResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Response {
    protected Map<String, String> params;
    protected static Logger logger = LogManager.getLogger(Response.class);

    public Response(Map<String, String> p) {
        this.params = p;
    }

    public String getVersion() {
        return this.params.get("VERS");
    }

    public String getParm(String key) {
        return this.params.get(key);
    }

    public String getMode() {
        return this.params.get("MODE");
    }

    public String getMerchantId() {
        return this.params.get("MERC");
    }

    public String getSessionId() {
        return this.params.get("SESS");
    }

    public String getTransactionId() {
        return this.params.get("TRAN");
    }

    public String getOrderNumber() {
        return this.params.get("ORDR");
    }

    public String getErrorCode() {
        return this.params.get("ERRO");
    }

    public String getAuto() {
        return this.params.get("AUTO");
    }

    public String getReason() {
        logger.info("The method com.kount.ris.Response.getReason() : String is deprecated. Use com.kount.ris.Response.getReasonCode() : String instead.");
        return this.params.get("REAS");
    }

    public String getReasonCode() {
        return this.params.get("REASON_CODE");
    }

    public String getScore() {
        return this.params.get("SCOR");
    }

    public String getOmniscore() {
        return this.params.get("OMNISCORE");
    }

    public String getGeox() {
        return this.params.get("GEOX");
    }

    public String getBrand() {
        return this.params.get("BRND");
    }

    public String getVelo() {
        return this.params.get("VELO");
    }

    public String getVmax() {
        return this.params.get("VMAX");
    }

    public String getNetwork() {
        return this.params.get("NETW");
    }

    public String getKnowYourCustomer() {
        return this.params.get("KYCF");
    }

    public String getRegion() {
        return this.params.get("REGN");
    }

    public String getKaptcha() {
        return this.params.get("KAPT");
    }

    public String getSite() {
        return this.params.get("SITE");
    }

    public String getProxy() {
        return this.params.get("PROXY");
    }

    public String getEmails() {
        return this.params.get("EMAILS");
    }

    public String getHttpCountry() {
        return this.params.get("HTTP_COUNTRY");
    }

    public String getTimeZone() {
        return this.params.get("TIMEZONE");
    }

    public String getCards() {
        return this.params.get("CARDS");
    }

    public String getPcRemote() {
        return this.params.get("PC_REMOTE");
    }

    public String getDevices() {
        return this.params.get("DEVICES");
    }

    public String getDeviceLayers() {
        return this.params.get("DEVICE_LAYERS");
    }

    public String getMobileForwarder() {
        return this.params.get("MOBILE_FORWARDER");
    }

    public String getVoiceDevice() {
        return this.params.get("VOICE_DEVICE");
    }

    public String getLocalTime() {
        return this.params.get("LOCALTIME");
    }

    public String getMobileType() {
        return this.params.get("MOBILE_TYPE");
    }

    public String getFingerPrint() {
        return this.params.get("FINGERPRINT");
    }

    public String getFlash() {
        return this.params.get("FLASH");
    }

    public String getLanguage() {
        return this.params.get("LANGUAGE");
    }

    public String getCountry() {
        return this.params.get("COUNTRY");
    }

    public String getJavaScript() {
        return this.params.get("JAVASCRIPT");
    }

    public String getCookies() {
        return this.params.get("COOKIES");
    }

    public String getMobileDevice() {
        return this.params.get("MOBILE_DEVICE");
    }

    public String getPiercedIPAddress() {
        return this.params.get("PIP_IPAD");
    }

    public String getPiercedIPAddressLatitude() {
        return this.params.get("PIP_LAT");
    }

    public String getPiercedIPAddressLongitude() {
        return this.params.get("PIP_LON");
    }

    public String getPiercedIPAddressCountry() {
        return this.params.get("PIP_COUNTRY");
    }

    public String getPiercedIPAddressRegion() {
        return this.params.get("PIP_REGION");
    }

    public String getPiercedIPAddressCity() {
        return this.params.get("PIP_CITY");
    }

    public String getPiercedIPAddressOrganization() {
        return this.params.get("PIP_ORG");
    }

    public String getIPAddress() {
        return this.params.get("IP_IPAD");
    }

    public String getIPAddressLatitude() {
        return this.params.get("IP_LAT");
    }

    public String getIPAddressLongitude() {
        return this.params.get("IP_LON");
    }

    public String getIPAddressCountry() {
        return this.params.get("IP_COUNTRY");
    }

    public String getIPAddressRegion() {
        return this.params.get("IP_REGION");
    }

    public String getIPAddressCity() {
        return this.params.get("IP_CITY");
    }

    public String getIPAddressOrganization() {
        return this.params.get("IP_ORG");
    }

    public String getDateDeviceFirstSeen() {
        return this.params.get("DDFS");
    }

    public String getUserAgentString() {
        return this.params.get("UAS");
    }

    public String getDeviceScreenResolution() {
        return this.params.get("DSR");
    }

    public String getOS() {
        return this.params.get("OS");
    }

    public String getBrowser() {
        return this.params.get("BROWSER");
    }

    public String getKcCustomerId() {
        return this.params.get("KC_CUSTOMER_ID");
    }

    public String getKcDecision() {
        return this.params.get("KC_DECISION");
    }

    public int getKcWarningCount() {
        try {
            String value = this.params.get("KC_WARNING_COUNT");
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned an KC_WARNING_COUNT field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public List<String> getKcWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        int warningCount = this.getKcWarningCount();
        for (int i = 1; i <= warningCount; ++i) {
            warnings.add(this.params.get("KC_WARNING_" + i));
        }
        return warnings;
    }

    public int getKcErrorCount() {
        try {
            String value = this.params.get("KC_ERROR_COUNT");
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned an KC_ERROR_COUNT field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public List<String> getKcErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        int errorCount = this.getKcErrorCount();
        for (int i = 1; i <= errorCount; ++i) {
            errors.add(this.params.get("KC_ERROR_" + i));
        }
        return errors;
    }

    public int getKcEventCount() {
        try {
            String value = this.params.get("KC_TRIGGERED_COUNT");
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned an KC_TRIGGERED_COUNT field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public List<KcEvent> getKcEvents() {
        ArrayList<KcEvent> events = new ArrayList<KcEvent>();
        int eventCount = this.getKcEventCount();
        for (int i = 1; i <= eventCount; ++i) {
            KcEvent event = new KcEvent(this.params.get("KC_EVENT_" + i + "_DECISION"), this.params.get("KC_EVENT_" + i + "_EXPRESSION"), this.params.get("KC_EVENT_" + i + "_CODE"));
            events.add(event);
        }
        return events;
    }

    public String toString() {
        String s = this.params.toString();
        return s.replaceAll(",", "\n");
    }

    public Map<String, String> getRulesTriggered() {
        HashMap<String, String> rules = new HashMap<String, String>();
        int rulesTriggeredCount = this.getNumberRulesTriggered();
        for (int i = 0; i < rulesTriggeredCount; ++i) {
            String ruleId = this.params.get("RULE_ID_" + i);
            rules.put(ruleId, this.params.get("RULE_DESCRIPTION_" + i));
        }
        return rules;
    }

    public int getNumberRulesTriggered() {
        try {
            return Integer.parseInt(this.params.get("RULES_TRIGGERED"));
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned a RULES_TRIGGERED field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public List<String> getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        int warningCount = this.getWarningCount();
        for (int i = 0; i < warningCount; ++i) {
            warnings.add(this.params.get("WARNING_" + i));
        }
        return warnings;
    }

    public int getWarningCount() {
        try {
            return Integer.parseInt(this.params.get("WARNING_COUNT"));
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned a WARNING_COUNT field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        int errorCount = this.getErrorCount();
        for (int i = 0; i < errorCount; ++i) {
            errors.add(this.params.get("ERROR_" + i));
        }
        return errors;
    }

    public int getErrorCount() {
        try {
            String value = this.params.get("ERROR_COUNT");
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned an ERROR_COUNT field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public static Response parseResponse(Reader r) throws RisResponseException {
        BufferedReader reader = new BufferedReader(r);
        HashMap<String, String> responseFields = new HashMap<String, String>();
        try {
            String line;
            while (null != (line = reader.readLine())) {
                String[] field = line.split("=", 2);
                if (field.length <= 1) continue;
                responseFields.put(field[0], field[1]);
            }
        }
        catch (IOException ioe) {
            logger.error("Error parsing RIS response", (Throwable)ioe);
            throw new RisResponseException("Error parsing RIS response");
        }
        return new Response(responseFields);
    }

    public Map<String, String> getLexisNexisCbdAttributes() {
        return this.getPrefixedResponseDataMap("CBD_");
    }

    public Map<String, String> getLexisNexisInstantIdAttributes() {
        return this.getPrefixedResponseDataMap("INSTANTID_");
    }

    public String getMasterCardFraudScore() {
        return this.params.get("MASTERCARD");
    }

    protected Map<String, String> getPrefixedResponseDataMap(String prefix) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (String key : this.params.keySet()) {
            if (!key.startsWith(prefix)) continue;
            data.put(key.substring(prefix.length()), this.params.get(key));
        }
        return data;
    }

    public Map<String, String> getCountersTriggered() {
        HashMap<String, String> counters = new HashMap<String, String>();
        int numCounters = this.getNumberCountersTriggered();
        for (int i = 0; i < numCounters; ++i) {
            counters.put(this.params.get("COUNTER_NAME_" + i), this.params.get("COUNTER_VALUE_" + i));
        }
        return counters;
    }

    public int getNumberCountersTriggered() {
        try {
            return Integer.parseInt(this.params.get("COUNTERS_TRIGGERED"));
        }
        catch (NumberFormatException nfe) {
            logger.error("RIS returned a COUNTERS_TRIGGERED field which could not be parsed to a number", (Throwable)nfe);
            return 0;
        }
    }

    public String getPreviouslyWhiteListed() {
        return this.params.get("PREVIOUSLY_WHITELISTED");
    }

    public String get3DSecureMerchantResponse() {
        return this.params.get("THREE_DS_MERCHANT_RESPONSE");
    }
}

