/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BearerAuthResponse {
    @JsonProperty(value="access_token")
    protected String accessToken = "";
    @JsonProperty(value="token_type")
    protected String tokenType = "";
    @JsonProperty(value="expires_in")
    protected String expiresIn = "";
    @JsonProperty(value="scope")
    protected String scope = "";
    protected OffsetDateTime createdAt = OffsetDateTime.MIN;
    protected OffsetDateTime expiresAt = OffsetDateTime.MIN;
    private boolean hasOffsetBeenAccountedFor = false;
    private int latencyBufferSeconds = 120;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OffsetDateTime getExpiresAt() {
        if (!this.expiresAt.equals(OffsetDateTime.MIN) && !this.hasOffsetBeenAccountedFor) {
            this.hasOffsetBeenAccountedFor = true;
            this.expiresAt = this.createdAt.plusSeconds(Integer.parseInt(this.expiresIn) - this.latencyBufferSeconds);
        }
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.hasOffsetBeenAccountedFor = false;
        this.expiresAt = expiresAt;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public int getLatencyBufferSeconds() {
        return this.latencyBufferSeconds;
    }

    public void setLatencyBufferSeconds(int latencyBufferSeconds) {
        this.latencyBufferSeconds = latencyBufferSeconds;
    }

    public BearerAuthResponse() {
    }

    public BearerAuthResponse(String accessToken, String tokenType, String expiresIn, String scope) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.expiresAt = OffsetDateTime.now().plusSeconds(Long.parseLong(expiresIn));
    }
}

