/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.util;

import com.github.fzakaria.ascii85.Ascii85;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Khash {
    private static final Logger logger = LogManager.getLogger(Khash.class);
    private static final String ACCEPTABLE_CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String configurationKey = System.getProperty("kount.config.key", null);
    private static Khash INSTANCE = null;

    public static Khash getInstance() throws RuntimeException, UnsupportedEncodingException {
        if (INSTANCE == null) {
            INSTANCE = new Khash();
        }
        return INSTANCE;
    }

    private Khash() throws RuntimeException {
        if (this.configurationKey == null || this.configurationKey.isEmpty()) {
            logger.error("No configuration key set at 'kount.config.key' system variable");
            throw new RuntimeException("No configuration key set");
        }
        this.configurationKey = new String(Ascii85.decode(this.configurationKey), StandardCharsets.UTF_8);
        try {
            String crypted = Khash.readCryptedConfigurationKey();
            String currentCrypted = Khash.sha256(this.configurationKey);
            if (!crypted.equals(currentCrypted)) {
                logger.error("The configuration key is incorrect");
                throw new IllegalArgumentException("The configuration key is incorrect");
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Could not verify the configuration key", (Throwable)nsae);
            throw new IllegalStateException("Could not verify the configuration key");
        }
    }

    public static String sha256(String plain) throws NoSuchAlgorithmException {
        MessageDigest d = MessageDigest.getInstance("sha-256");
        byte[] digest = d.digest(plain.getBytes(StandardCharsets.UTF_8));
        StringBuffer hexString = new StringBuffer();
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static String readCryptedConfigurationKey() {
        try (Scanner scanner = new Scanner(Objects.requireNonNull(Khash.class.getClassLoader().getResourceAsStream("configuration.key.crypt")), "UTF-8");){
            String string = scanner.nextLine();
            return string;
        }
    }

    public String hashPaymentToken(String token) throws NoSuchAlgorithmException {
        int binLength = 6;
        return null == token ? "" : token.substring(0, 6) + this.hash(token);
    }

    public String hashGiftCard(long merchantId, String token) throws NoSuchAlgorithmException {
        return merchantId + this.hash(token);
    }

    protected String hash(String token) throws NoSuchAlgorithmException {
        int loopMax = 28;
        int hexChunk = 7;
        int aLength = 36;
        StringBuilder hashed = new StringBuilder();
        String sha1 = Khash.sha1(token + "." + this.configurationKey);
        for (int i = 0; i < 28; i += 2) {
            hashed.append(ACCEPTABLE_CHARACTERS.charAt(Integer.parseInt(sha1.substring(i, 7 + i), 16) % 36));
        }
        return hashed.toString();
    }

    protected static String sha1(String plainText) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(plainText.getBytes());
        byte[] b = md.digest();
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte value : b) {
            int v = value & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }
}

