/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kount.ris.Response;
import com.kount.ris.transport.BearerAuthResponse;
import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisResponseException;
import com.kount.ris.util.RisTransportException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.ConfigurationException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HttpApiTransport
extends Transport {
    public static final int DEFAULT_MAX_CONNECTIONS = 256;
    public static final int DEFAULT_CONNECTION_IDLE_TIMEOUT_MINUTES = 1;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public static final String CUSTOM_HEADER_MERCHANT_ID = "X-Kount-Merc-Id";
    public static final String CUSTOM_HEADER_API_KEY = "X-Kount-Api-Key";
    protected static final Lock connManagerWriteLock = new ReentrantLock();
    protected boolean migrationModeEnabled = false;
    protected String paymentsFraudApiEndpoint = "https://api.kount.com/commerce/ris";
    protected String paymentsFraudAuthEndpoint = "https://login.kount.com/oauth2/ausdppksgrbyM0abp357/v1/token";
    protected String paymentsFraudClientId = "";
    protected String paymentsFraudApiKey = "";
    protected BearerAuthResponse bearer = new BearerAuthResponse();
    protected static final ReentrantReadWriteLock bearerRWLock = new ReentrantReadWriteLock();
    protected static final Lock bearerReadLock = bearerRWLock.readLock();
    protected static final Lock bearerWriteLock = bearerRWLock.writeLock();
    public static final String PF_AUTH_HEADER = "Authorization";
    private boolean forceUtf8 = false;
    private static final Logger logger = LogManager.getLogger(HttpApiTransport.class);
    private static final PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMinutes((long)1L)).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.FIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMilliseconds((long)10000L)).setConnectTimeout(Timeout.ofMilliseconds((long)10000L)).setTimeToLive(TimeValue.ofMinutes((long)1L)).build()).build();
    protected String apiKey;
    private CloseableHttpClient httpClient;
    private int connectionTimeToLive;

    public HttpApiTransport() {
        this.connectTimeout = 10000;
        this.readTimeout = 10000;
        this.connectionTimeToLive = 1;
    }

    public HttpApiTransport(URL url, String key) {
        this();
        this.risServerUrl = url.toString();
        this.apiKey = key;
    }

    public HttpApiTransport(URL url, String key, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws ConfigurationException {
        this(url, key);
        this.forceUtf8 = forceUtf8;
        this.configureMigrationMode(migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint);
    }

    public HttpApiTransport(URL url, String key, int maxConnections, int maxConnectionsPerRoute) {
        this();
        this.risServerUrl = url.toString();
        this.apiKey = key;
        connManagerWriteLock.lock();
        connManager.setMaxTotal(maxConnections);
        connManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
        connManagerWriteLock.unlock();
    }

    public HttpApiTransport(URL url, String key, int maxConnections, int maxConnectionsPerRoute, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws ConfigurationException {
        this(url, key, maxConnections, maxConnectionsPerRoute);
        this.forceUtf8 = forceUtf8;
        this.configureMigrationMode(migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint);
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public void setConnectionTimeToLive(int minutes) {
        this.connectionTimeToLive = minutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpApiTransport httpApiTransport = this;
            synchronized (httpApiTransport) {
                this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
            }
        }
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayInputStream readAllInput(HttpEntity entity) throws IOException {
        try {
            int nRead;
            InputStream is = entity.getContent();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response sendRequest(Map<String, String> params) throws RisTransportException {
        if (!params.containsKey("PTOK") || "KHASH".equals(params.get("PENC")) && null == params.get("PTOK")) {
            params.put("PENC", "");
        }
        try {
            HttpPost httpPost;
            if (this.migrationModeEnabled && this.bearer.expiresAt.isBefore(OffsetDateTime.now().plusSeconds(60L))) {
                this.refreshAuthToken();
            }
            if (this.migrationModeEnabled) {
                httpPost = new HttpPost(this.paymentsFraudApiEndpoint);
                bearerReadLock.lock();
                try {
                    httpPost.addHeader(PF_AUTH_HEADER, (Object)(this.bearer.tokenType + " " + this.bearer.accessToken));
                }
                finally {
                    bearerReadLock.unlock();
                }
                String clientId = this.paymentsFraudClientId;
                params.put("MERC", clientId);
                httpPost.addHeader(CUSTOM_HEADER_MERCHANT_ID, (Object)clientId);
            } else {
                httpPost = new HttpPost(this.risServerUrl);
                httpPost.addHeader(CUSTOM_HEADER_API_KEY, (Object)this.apiKey);
                httpPost.addHeader(CUSTOM_HEADER_MERCHANT_ID, (Object)params.get("MERC"));
            }
            httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            if (this.forceUtf8) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpApiTransport.convertToNameValuePair(params), StandardCharsets.UTF_8));
            } else {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpApiTransport.convertToNameValuePair(params)));
            }
            try (CloseableHttpResponse httpResponse = this.getHttpClient().execute((ClassicHttpRequest)httpPost);){
                Response response;
                try (InputStreamReader reader = new InputStreamReader(HttpApiTransport.readAllInput(httpResponse.getEntity()));){
                    response = this.parse(reader);
                }
                return response;
            }
        }
        catch (Exception ioe) {
            logger.error("Error fetching RIS response", (Throwable)ioe);
            throw new RisTransportException("An error occurred while getting the RIS response", ioe);
        }
    }

    protected Response parse(Reader r) throws RisResponseException {
        logger.trace("parse()");
        return Response.parseResponse(r);
    }

    protected void configureMigrationMode(boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint) throws ConfigurationException {
        this.migrationModeEnabled = migrationModeEnabled;
        this.paymentsFraudApiKey = paymentsFraudApiKey;
        this.paymentsFraudClientId = paymentsFraudClientId;
        this.paymentsFraudApiEndpoint = paymentsFraudApiEndpoint;
        this.paymentsFraudAuthEndpoint = paymentsFraudAuthEndpoint;
        if (migrationModeEnabled) {
            if (this.paymentsFraudApiKey.isEmpty()) {
                throw new ConfigurationException("migration mode is set to enabled, but Payments Fraud API key is missing");
            }
            if (this.paymentsFraudClientId.isEmpty()) {
                throw new ConfigurationException("migration mode is set to enabled, but Payments Fraud Client ID is missing");
            }
            if (this.paymentsFraudApiEndpoint.isEmpty()) {
                throw new ConfigurationException("migration mode is set to enabled, but Payments Fraud API endpoint is missing");
            }
            if (this.paymentsFraudAuthEndpoint.isEmpty()) {
                throw new ConfigurationException("migration mode is set to enabled, but Payments Fraud Auth endpoint is missing");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshAuthToken() throws RisTransportException {
        block24: {
            bearerWriteLock.lock();
            if (this.bearer.getExpiresAt().isAfter(OffsetDateTime.now().plusSeconds(60L))) {
                return;
            }
            try {
                HttpPost httpPost = new HttpPost(this.paymentsFraudAuthEndpoint);
                httpPost.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                httpPost.addHeader(PF_AUTH_HEADER, (Object)("Basic " + this.paymentsFraudApiKey));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("grant_type", "client_credentials");
                params.put("scope", "k1_integration_api");
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpApiTransport.convertToNameValuePair(params)));
                try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                     CloseableHttpResponse httpResponse = httpClient.execute((ClassicHttpRequest)httpPost);
                     InputStreamReader reader = new InputStreamReader(HttpApiTransport.readAllInput(httpResponse.getEntity()));){
                    if (httpResponse.getCode() < 400) {
                        ObjectMapper objectMapper = new ObjectMapper();
                        BearerAuthResponse authResponse = (BearerAuthResponse)objectMapper.readValue((Reader)reader, BearerAuthResponse.class);
                        bearerReadLock.lock();
                        this.bearer = authResponse;
                        bearerReadLock.unlock();
                        break block24;
                    }
                    bearerWriteLock.unlock();
                    String message = "Error fetching auth token: received " + httpResponse.getCode() + " " + httpResponse.getReasonPhrase();
                    logger.error(message);
                    throw new RisTransportException("An error occurred while reading the auth token response: " + message);
                }
                catch (Exception ioe) {
                    bearerWriteLock.unlock();
                    logger.error("Error fetching updating bearer auth token", (Throwable)ioe);
                    throw new RisTransportException("An error occurred while getting the auth token", ioe);
                }
            }
            finally {
                bearerWriteLock.unlock();
            }
        }
    }

    static {
        connManagerWriteLock.lock();
        connManager.setMaxTotal(256);
        connManager.setDefaultMaxPerRoute(256);
        connManagerWriteLock.unlock();
    }
}

