/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris.transport;

import com.kount.ris.Response;
import com.kount.ris.util.RisTransportException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Transport {
    private static Object String;
    protected String risServerUrl;
    protected int connectTimeout;
    protected int readTimeout;

    public abstract Response sendRequest(Map<String, String> var1) throws RisTransportException;

    public void setRisServerUrl(String url) {
        this.risServerUrl = url;
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    protected static void writeParametersToOutput(OutputStreamWriter out, Map<String, String> params) throws IOException {
        for (String key : params.keySet()) {
            String value = params.get(key);
            out.write(key);
            out.write(61);
            out.write(URLEncoder.encode(null == value ? "" : value, "UTF-8"));
            out.write(38);
        }
    }

    public static List<NameValuePair> convertToNameValuePair(Map<String, String> params) {
        ArrayList<NameValuePair> nvpList = new ArrayList<NameValuePair>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nvpList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return nvpList;
    }
}

