/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris;

import com.kount.ris.Request;
import com.kount.ris.Response;
import com.kount.ris.transport.HttpApiTransport;
import com.kount.ris.transport.KountHttpTransport;
import com.kount.ris.transport.Transport;
import com.kount.ris.util.RisException;
import com.kount.ris.util.RisResponseException;
import com.kount.ris.util.RisTransportException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.naming.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KountRisClient {
    private static final Logger logger = LogManager.getLogger(KountRisClient.class);
    protected Transport transport;
    protected StringBuilder errorMessage = null;
    protected String apiKey;

    public KountRisClient() {
    }

    public KountRisClient(String phrase, String url, String p12file) throws RisTransportException {
        logger.debug("RIS endpoint URL [{}]", (Object)url);
        this.transport = new KountHttpTransport(phrase, url, p12file);
    }

    public KountRisClient(String phrase, String url, InputStream p12in) throws RisTransportException {
        this.transport = new KountHttpTransport(phrase, url, p12in);
    }

    public KountRisClient(URL url, File apiKeyFile) throws RisTransportException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey);
    }

    public KountRisClient(URL url, File apiKeyFile, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint) throws RisTransportException, ConfigurationException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, false);
    }

    public KountRisClient(URL url, File apiKeyFile, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws RisTransportException, ConfigurationException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, forceUtf8);
    }

    public KountRisClient(URL url, File apiKeyFile, int connectionPoolThreads, int connectionPerRoute, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint) throws RisTransportException, ConfigurationException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, false);
    }

    public KountRisClient(URL url, File apiKeyFile, int connectionPoolThreads, int connectionPerRoute, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws RisTransportException, ConfigurationException {
        this.getApiKey(apiKeyFile);
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, forceUtf8);
    }

    public KountRisClient(URL url, String key) {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey);
    }

    public KountRisClient(URL url, String key, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint) throws ConfigurationException {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, false);
    }

    public KountRisClient(URL url, String key, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws ConfigurationException {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, forceUtf8);
    }

    public KountRisClient(URL url, String key, int connectionPoolThreads, int connectionPerRoute) {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute);
    }

    public KountRisClient(URL url, String key, int connectionPoolThreads, int connectionPerRoute, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint) throws ConfigurationException {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, false);
    }

    public KountRisClient(URL url, String key, int connectionPoolThreads, int connectionPerRoute, boolean migrationModeEnabled, String paymentsFraudApiKey, String paymentsFraudClientId, String paymentsFraudApiEndpoint, String paymentsFraudAuthEndpoint, boolean forceUtf8) throws ConfigurationException {
        this.apiKey = key;
        this.transport = new HttpApiTransport(url, this.apiKey, connectionPoolThreads, connectionPerRoute, migrationModeEnabled, paymentsFraudApiKey, paymentsFraudClientId, paymentsFraudApiEndpoint, paymentsFraudAuthEndpoint, forceUtf8);
    }

    public void setTransport(Transport t) {
        this.transport = t;
    }

    public void setApiKey(String key) {
        this.apiKey = key;
    }

    public Response process(Request r) throws RisException {
        logger.trace("process()");
        if (this.transport != null) {
            return this.transport.sendRequest(r.getParams());
        }
        throw new RisTransportException("No transport was specified, unable to send request.");
    }

    protected Response parse(Reader r) throws RisResponseException {
        logger.trace("parse()");
        return Response.parseResponse(r);
    }

    protected final void getApiKey(File apiKeyFile) throws RisTransportException {
        logger.trace("getApiKey()");
        if (this.apiKey == null && apiKeyFile != null) {
            try {
                byte[] keyBytes = Files.readAllBytes(Paths.get(apiKeyFile.toURI()));
                String key = new String(keyBytes, StandardCharsets.UTF_8);
                this.apiKey = key.trim();
            }
            catch (IOException e) {
                logger.error("API Key file ({}) could not be found:\n{}", (Object)apiKeyFile, (Object)e);
                throw new RisTransportException("API Key file (" + apiKeyFile + ") could not be found:\n" + e);
            }
        }
    }
}

