/*
 * Decompiled with CFR 0.152.
 */
package com.kount.ris;

import com.kount.ris.Config;
import com.kount.ris.util.AuthorizationStatus;
import com.kount.ris.util.BankcardReply;
import com.kount.ris.util.Khash;
import com.kount.ris.util.MerchantAcknowledgment;
import com.kount.ris.util.payment.BillMeLaterPayment;
import com.kount.ris.util.payment.CardPayment;
import com.kount.ris.util.payment.CheckPayment;
import com.kount.ris.util.payment.GiftCardPayment;
import com.kount.ris.util.payment.GooglePayment;
import com.kount.ris.util.payment.GreenDotMoneyPakPayment;
import com.kount.ris.util.payment.NoPayment;
import com.kount.ris.util.payment.Payment;
import com.kount.ris.util.payment.PaypalPayment;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Request {
    protected Map<String, String> params = new HashMap<String, String>();
    protected Logger logger = LogManager.getLogger(Request.class);
    protected boolean closeOnFinish;
    public static final Config config = new Config();

    public Request() {
        this.params.put("PENC", "KHASH");
        this.params.put("VERS", Request.config.VERS);
        this.params.put("SDK", "JAVA");
    }

    public String toString() {
        String s = this.getParams().toString();
        return s.replaceAll(",", "\n");
    }

    public Request setParm(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public Request setVersion(String version) {
        this.params.put("VERS", version);
        return this;
    }

    public Request setSessionId(String sessionId) {
        this.params.put("SESS", sessionId);
        return this;
    }

    public Request setMerchantId(long merchantId) {
        this.params.put("MERC", Long.valueOf(merchantId).toString());
        return this;
    }

    public Request setKcCustomerId(String id) {
        this.params.put("CUSTOMER_ID", id);
        return this;
    }

    public Request setOrderNumber(String orderNumber) {
        this.params.put("ORDR", orderNumber);
        return this;
    }

    public Request setMerchantAcknowledgment(MerchantAcknowledgment merchantAcknowledgment) {
        this.params.put("MACK", merchantAcknowledgment.toString());
        return this;
    }

    public Request setAuthorizationStatus(AuthorizationStatus authorizationStatus) {
        this.params.put("AUTH", authorizationStatus.toString());
        return this;
    }

    public Request setAvsZipReply(BankcardReply avsZipReply) {
        this.params.put("AVSZ", avsZipReply.toString());
        return this;
    }

    public Request setAvsAddressReply(BankcardReply avsAddressReply) {
        this.params.put("AVST", avsAddressReply.toString());
        return this;
    }

    public Request setCvvReply(BankcardReply cvvReply) {
        this.params.put("CVVR", cvvReply.toString());
        return this;
    }

    public Request setPayment(Payment p) throws UnsupportedEncodingException {
        String type = p.getPaymentType();
        String token = p.getPaymentToken();
        if (this.isSetKhashPaymentEncoding() && !(p instanceof NoPayment) && !p.isKhashed()) {
            if (p.getPaymentTokenLast4().isEmpty()) {
                p.calculateLast4();
            }
            try {
                if (p instanceof GiftCardPayment) {
                    long merchantId = Long.parseLong(this.params.get("MERC"));
                    token = Khash.getInstance().hashGiftCard(merchantId, token);
                } else {
                    token = Khash.getInstance().hashPaymentToken(token);
                }
                p.setKhashed(true);
            }
            catch (NoSuchAlgorithmException nsae) {
                this.logger.error("Unable to create payment token hash. Caught exception java.security.NoSuchAlgorithmException. KHASH payment encoding disabled");
                this.params.put("PENC", "");
            }
            catch (NumberFormatException nfe) {
                this.logger.error("Error converting Merchant ID to integer value. Set a valid Merchant ID.", (Throwable)nfe);
                throw nfe;
            }
        }
        this.params.put("PTOK", token);
        this.params.put("PTYP", type);
        this.params.put("LAST4", p.getPaymentTokenLast4());
        return this;
    }

    public Request setPaymentMasked(Payment p) throws UnsupportedEncodingException {
        String type = p.getPaymentType();
        String token = p.getPaymentToken();
        if (p instanceof CardPayment && !p.isKhashed()) {
            if (p.getPaymentTokenLast4().isEmpty()) {
                p.calculateLast4();
            }
            token = Request.maskToken(token);
            this.params.put("PTOK", token);
            this.params.put("PTYP", type);
            this.params.put("LAST4", p.getPaymentTokenLast4());
            this.params.put("PENC", "MASK");
            return this;
        }
        this.logger.warn("setPaymentMasked: provided payment is not a CardPayment, applying khash instead of masking");
        return this.setPayment(p);
    }

    private static String maskToken(String token) {
        StringBuilder builder = new StringBuilder();
        builder.append(token, 0, 6);
        for (int i = 6; i < token.length() - 4; ++i) {
            builder.append('X');
        }
        builder.append(token.substring(token.length() - 4));
        return builder.toString();
    }

    public Request setPayment(String ptyp, String ptok) throws UnsupportedEncodingException {
        if ("BLML".equals(ptyp)) {
            this.setPayment(new BillMeLaterPayment(ptok));
        } else if ("CARD".equals(ptyp)) {
            this.setPayment(new CardPayment(ptok));
        } else if ("CHEK".equals(ptok) || "CHECK".equals(ptok)) {
            this.setPayment(new CheckPayment(ptok));
        } else if ("GIFT".equals(ptyp)) {
            this.setPayment(new GiftCardPayment(ptok));
        } else if ("GOOG".equals(ptyp)) {
            this.setPayment(new GooglePayment(ptok));
        } else if ("GDMP".equals(ptyp)) {
            this.setPayment(new GreenDotMoneyPakPayment(ptok));
        } else if ("NONE".equals(ptyp)) {
            this.setPayment(new NoPayment());
        } else if ("PYPL".equals(ptyp)) {
            this.setPayment(new PaypalPayment(ptok));
        } else {
            this.setPayment(new Payment(ptyp, ptok));
        }
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Request setKhashPaymentEncoding() {
        this.logger.info("The method com.kount.ris.Request.setKhashPaymentEncoding() : Request is deprecated. Use com.kount.ris.Request.setKhashPaymentEncoding(boolean) : Request instead.");
        this.params.put("PENC", "KHASH");
        return this;
    }

    public Request setKhashPaymentEncoding(boolean enabled) {
        if (enabled) {
            this.params.put("PENC", "KHASH");
        } else {
            this.params.put("PENC", "");
        }
        return this;
    }

    protected boolean isSetKhashPaymentEncoding() {
        return this.params.containsKey("PENC") && "KHASH".equals(this.params.get("PENC"));
    }

    public Request setCloseOnFinish(boolean cof) {
        this.closeOnFinish = cof;
        return this;
    }

    public Request setLbin(String lbin) {
        this.params.put("LBIN", lbin);
        return this;
    }
}

