/*
 * Decompiled with CFR 0.152.
 */
package com.krrrr38.jabot.plugin.adapter;

import com.krrrr38.jabot.plugin.Plugin;
import com.krrrr38.jabot.plugin.message.ReceiveMessage;
import com.krrrr38.jabot.plugin.message.SendMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public abstract class Adapter
extends Plugin {
    private volatile boolean running = false;
    private String namespace;
    private String botName;
    private Consumer<ReceiveMessage> receiver;

    protected String getNamespace() {
        return this.namespace;
    }

    public void setup(String namespace, String botName, Consumer<ReceiveMessage> receiver, Map<String, String> options) {
        if (botName == null || botName.isEmpty()) {
            botName = "jabot";
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver required");
        }
        this.namespace = namespace;
        this.botName = botName;
        this.receiver = receiver;
        this.afterSetup(options);
    }

    public final void listen() {
        this.connectAction();
        this.running = true;
        while (this.running) {
            this.receives().stream().forEach(this.receiver::accept);
        }
    }

    public final void stop() {
        this.running = false;
    }

    protected String getBotName() {
        return this.botName;
    }

    public abstract ReceiveMessage receive();

    public Collection<ReceiveMessage> receives() {
        return Collections.singletonList(this.receive());
    }

    public abstract void post(SendMessage var1);

    public abstract void connectAction();
}

