/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.fileutils;

import com.ksc.mission.base.fileutils.ExcelReader;
import com.opencsv.CSVReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Supplier;

public class CloseableReader
implements AutoCloseable {
    protected final Supplier<Iterator<String[]>> iteratorSupplier;
    protected final Supplier<Object> closer;

    public CloseableReader(CSVReader reader) {
        this.iteratorSupplier = () -> reader.iterator();
        this.closer = () -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        };
    }

    public CloseableReader(ExcelReader reader, int sheetNumber) {
        this.iteratorSupplier = () -> reader.iteratorForSheet(sheetNumber);
        this.closer = () -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        };
    }

    @Override
    public void close() throws Exception {
        this.closer.get();
    }

    public Iterator<String[]> iterator() throws Exception {
        return this.iteratorSupplier.get();
    }
}

