/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.fileutils;

import com.ksc.mission.base.fileutils.ExcelIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
implements Closeable {
    Workbook workbook = null;

    public ExcelReader(String fileName) {
        this.workbook = this.workbookFor(fileName);
    }

    public Workbook workbookFor(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        try {
            FileInputStream excelFile = new FileInputStream(new File(fileName));
            if (extension.equalsIgnoreCase("xls")) {
                return new HSSFWorkbook((InputStream)excelFile);
            }
            return new XSSFWorkbook((InputStream)excelFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ExcelIterator iteratorForSheet(int sheetNumber) {
        return this.iteratorForSheet(sheetNumber, true);
    }

    public ExcelIterator iteratorForSheet(int sheetNumber, boolean hasHeader) {
        ExcelIterator iterator = null;
        Sheet datatypeSheet = this.workbook.getSheetAt(sheetNumber);
        iterator = new ExcelIterator(datatypeSheet.iterator());
        if (hasHeader && iterator.hasNext()) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public void close() throws IOException {
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

