/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.fileutils;

import com.ksc.mission.base.fileutils.CloseableReader;
import com.ksc.mission.base.fileutils.ExcelReader;
import com.ksc.mission.base.interfaces.ICreate;
import com.ksc.mission.base.interfaces.ISave;
import com.ksc.mission.base.interfaces.Initializable;
import com.opencsv.CSVIterator;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    String basePath;

    public FileUtil(String basePath) {
        this.basePath = basePath;
    }

    public String asJavaPackageName() {
        String packageName = this.basePath;
        if (packageName.startsWith("java")) {
            packageName = packageName.substring(4);
        }
        packageName = packageName.replace("/", ".");
        if ((packageName = packageName.replace("\\", ".")).startsWith(".")) {
            packageName = packageName.substring(1);
        }
        return packageName;
    }

    public void doWithLinesIterator(String fileName, Consumer<Iterator<String[]>> block) {
        try (CloseableReader reader = this.getReader(fileName, true);){
            block.accept(reader.iterator());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doWithLinesIterator(String fileName, boolean hasHeader, Consumer<Iterator<String[]>> block) {
        try (CloseableReader reader = this.getReader(fileName, hasHeader);){
            block.accept(reader.iterator());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E resultFromLinesIterator(String fileName, Function<Iterator<String[]>, E> block) {
        try (CloseableReader reader = this.getReader(fileName, true);){
            E e = block.apply(reader.iterator());
            return e;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E> E resultFromLinesIterator(String fileName, boolean hasHeader, Function<Iterator<String[]>, E> block) {
        try (CloseableReader reader = this.getReader(fileName, hasHeader);){
            E e = block.apply(reader.iterator());
            return e;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public <E extends Initializable<?>, C extends ICreate<E>> void readAll(C creator, String fileName) {
        this.doWithLinesIterator(fileName, iterator -> this.read(creator, (Iterator<String[]>)iterator, (Consumer)null));
    }

    public <E extends Initializable<?>, C extends ICreate<E>> void readAll(C creator, String fileName, Consumer<E> precondition) {
        this.doWithLinesIterator(fileName, iterator -> this.read(creator, (Iterator<String[]>)iterator, precondition));
    }

    public <E extends Initializable<?>, C extends ICreate<E>> void read(C creator, CSVIterator iterator) {
        this.read(creator, (Iterator<String[]>)iterator, (Consumer)null);
    }

    public <E extends Initializable<?>, C extends ICreate<E>> void read(C creator, Iterator<String[]> iterator, Consumer<E> precondition) {
        this.read(creator, iterator, precondition, null);
    }

    public <E extends Initializable<?>, C extends ICreate<E>> void read(C creator, Iterator<String[]> iterator, Consumer<E> precondition, Function<Iterator<String>, Boolean> untilCondition) {
        try {
            String[] nextLine;
            while (iterator.hasNext() && (nextLine = iterator.next()) != null && (untilCondition == null || !untilCondition.apply(this.getTrimWhitespaceIterator(nextLine = iterator.next())).booleanValue())) {
                Initializable element = (Initializable)creator.create();
                if (precondition != null) {
                    precondition.accept(element);
                }
                element.initializeFromStrings(this.getTrimWhitespaceIterator(nextLine));
                ((ISave)element).save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public <E> List<E> read(Iterator<String[]> iterator, Function<Iterator<String>, E> doForEach, Function<Iterator<String>, Boolean> untilCondition) {
        String[] nextLine = null;
        ArrayList<E> list = new ArrayList<E>();
        try {
            while (iterator.hasNext() && (nextLine = iterator.next()) != null && (untilCondition == null || !untilCondition.apply(this.getTrimWhitespaceIterator(nextLine)).booleanValue())) {
                E current = doForEach.apply(this.getTrimWhitespaceIterator(nextLine));
                if (current == null) continue;
                list.add(current);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public <E extends Initializable<?>> void doWithIterator(Iterator<String[]> iterator, Consumer<Iterator<String>> doForEach, Function<Iterator<String>, Boolean> untilCondition) {
        String[] nextLine = null;
        try {
            while (iterator.hasNext() && (nextLine = iterator.next()) != null && (untilCondition == null || !untilCondition.apply(this.getTrimWhitespaceIterator(nextLine)).booleanValue())) {
                doForEach.accept(this.getTrimWhitespaceIterator(nextLine));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Iterator<String> getTrimWhitespaceIterator(String[] strings) {
        return Arrays.asList(strings).stream().map(str -> str.trim()).iterator();
    }

    public CloseableReader getReader(String fileName, boolean hasHeader) {
        String fileExtension;
        switch (fileExtension = FilenameUtils.getExtension((String)fileName).toLowerCase()) {
            case "csv": {
                return new CloseableReader(this.getCSVReader(fileName, hasHeader, ','));
            }
            case "tsv": {
                return new CloseableReader(this.getCSVReader(fileName, hasHeader, '\t'));
            }
            case "xls": 
            case "xlsx": {
                return new CloseableReader(this.getExcelReader(fileName), 0);
            }
        }
        return null;
    }

    private ExcelReader getExcelReader(String fileName) {
        return new ExcelReader(fileName);
    }

    public CSVReader getCSVReader(String fileName, boolean hasHeader, char separator) {
        try {
            FileInputStream inputStream = new FileInputStream(this.basePath + fileName);
            return this.getCSVReader(inputStream, hasHeader, separator);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected CSVReader getCSVReader(InputStream inputStream, boolean hasHeader, char separator) {
        CSVParser parser = new CSVParserBuilder().withSeparator(separator).withIgnoreQuotations(false).build();
        return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream)).withSkipLines(hasHeader ? 1 : 0).withCSVParser((ICSVParser)parser).build();
    }
}

