/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.fileutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileUtil {
    protected final List<String> fileList = new ArrayList<String>();
    protected final String sourceDirectory;
    protected final String outputFile;

    public ZipFileUtil(String sourceDirectory, String outputFile) {
        this.sourceDirectory = sourceDirectory;
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip() {
        this.generateRootFileList(new File(this.sourceDirectory));
        byte[] buffer = new byte[1024];
        String source = new File(this.sourceDirectory).getName();
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(this.outputFile);
            zos = new ZipOutputStream(fos);
            System.out.println("Output to Zip : " + this.outputFile);
            FileInputStream in = null;
            for (String file : this.fileList) {
                System.out.println("File Added : " + file);
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                try {
                    int len;
                    in = new FileInputStream(this.sourceDirectory + File.separator + file);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                }
                finally {
                    in.close();
                }
            }
            zos.closeEntry();
            System.out.println("Folder successfully compressed");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                zos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void generateRootFileList(File node) {
        if (node.isFile()) {
            this.fileList.add(this.generateZipEntry(node.toString()));
        } else {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                this.generateFileList(new File(this.sourceDirectory + "/" + filename));
            }
        }
    }

    public void generateFileList(File node) {
        if (node.isFile()) {
            this.fileList.add(this.generateZipEntry(node.toString()));
        } else {
            String[] fileNames = node.list();
            if (fileNames != null) {
                for (String filename : fileNames) {
                    this.generateFileList(new File(node, filename));
                }
            }
        }
    }

    private String generateZipEntry(String file) {
        return file.substring(this.sourceDirectory.length() + 1, file.length());
    }
}

