/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.http;

import com.ksc.mission.base.http.HttpConnectorSpec;
import com.ksc.mission.base.http.IHttpPayload;
import com.ksc.mission.base.interfaces.IMessage;
import com.ksc.mission.base.relatedobjects.OwnedService;
import java.io.Serializable;
import javax.ws.rs.core.Response;

public class HttpConnector
extends OwnedService {
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final HttpConnectorSpec httpConnectorSpec;

    public HttpConnector(String identifier, HttpConnectorSpec httpConnectorSpec) {
        this.id = identifier;
        this.httpConnectorSpec = httpConnectorSpec;
    }

    public void get(String path) {
        this.logInfo(this.httpConnectorSpec.get(path, "application/text").getEntity().toString());
    }

    public void get(String path, IMessage publishMsg) {
        try {
            publishMsg.respondWith((Serializable)this.getJson(path).getEntity());
        }
        catch (Exception e) {
            publishMsg.respondWith(e);
        }
    }

    public void post(String path, IMessage publishMsg) {
        try {
            publishMsg.respondWith((Serializable)this.postJson(path, publishMsg.getPayload()).getEntity());
        }
        catch (Exception e) {
            publishMsg.respondWith(e);
        }
    }

    public Response postJson(String path, Serializable body) {
        return this.httpConnectorSpec.postJson(path, body);
    }

    public Response post(IHttpPayload httpMsg) {
        return this.httpConnectorSpec.postJson(httpMsg.getPath(), httpMsg.getBody());
    }

    public Response get(IHttpPayload httpMsg) {
        return this.getJson(httpMsg.getPath());
    }

    public Response getJson(String path) {
        return this.httpConnectorSpec.getJson(path);
    }

    protected IHttpPayload getHttpMessage(IMessage msg) {
        return (IHttpPayload)msg.getPayload();
    }

    public String getId() {
        return this.id;
    }
}

