/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.mission.base.http;

import com.ksc.mission.base.http.HttpStreamingOutput;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class HttpConnectorSpec {
    protected final WebTarget target;
    protected final MultivaluedMap<String, Object> headers;

    public HttpConnectorSpec(WebTarget target, MultivaluedMap<String, Object> headers) {
        this.target = target;
        this.headers = headers;
    }

    public HttpConnectorSpec(String url) {
        this.headers = new MultivaluedHashMap();
        this.target = ClientBuilder.newClient().target(url);
    }

    public HttpConnectorSpec(String url, Map<String, List<Object>> headers) {
        this.headers = new MultivaluedHashMap(headers);
        this.target = ClientBuilder.newClient().target(url);
    }

    public Response getJson(String path) {
        return this.get(path, "application/json");
    }

    public <BODY> Response postJson(String path, BODY body) {
        return this.post(path, "application/json", Entity.json(body));
    }

    public <BODY> Response postForm(String path, Form form) {
        return this.post(path, "application/x-www-form-urlencoded", Entity.form((Form)form));
    }

    public <BODY> Response postForm(String path, MultivaluedMap<String, String> formData) {
        return this.post(path, "multipart/form-data", Entity.form(formData));
    }

    public Response get(String path, String mediaType) {
        return this.get(path, mediaType, response -> {
            response.bufferEntity();
            return response;
        });
    }

    public Response post(String path, String mediaType, Entity<?> entity) {
        return this.post(path, mediaType, entity, response -> {
            response.bufferEntity();
            return response;
        });
    }

    public <RESULT> RESULT get(String path, String mediaType, Function<Response, RESULT> doWithResponse) {
        try (Response response = this.target.path(path).request().headers(this.headers).get();){
            RESULT RESULT = doWithResponse.apply(response);
            return RESULT;
        }
    }

    public <RESULT> RESULT post(String path, String mediaType, Entity<?> entity, Function<Response, RESULT> doWithResponse) {
        try (Response response = this.target.path(path).request(new String[]{mediaType}).headers(this.headers).post(entity);){
            RESULT RESULT = doWithResponse.apply(response);
            return RESULT;
        }
    }

    public HttpStreamingOutput getOutputStream(String path) throws Exception {
        return new HttpStreamingOutput(this, path);
    }
}

